/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.ddl;

import com.google.common.collect.Maps;
import com.netflix.astyanax.ddl.ColumnDefinition;
import com.netflix.astyanax.ddl.FieldMetadata;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.thrift.ThriftTypes;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftColumnDefinitionImpl
implements ColumnDefinition {
    private static final Map<String, FieldMetadata> fieldsMetadata = Maps.newHashMap();
    private final ColumnDef columnDef;

    public ThriftColumnDefinitionImpl() {
        this.columnDef = new ColumnDef();
    }

    public ThriftColumnDefinitionImpl(ColumnDef columnDef) {
        this.columnDef = columnDef;
    }

    ColumnDef getThriftColumnDefinition() {
        return this.columnDef;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.columnDef.getIndex_options();
    }

    @Override
    public ColumnDefinition setOptions(Map<String, String> index_options) {
        this.columnDef.setIndex_options(index_options);
        return this;
    }

    @Override
    public ColumnDefinition setName(String name) {
        this.columnDef.setName(StringSerializer.get().toBytes(name));
        return this;
    }

    @Override
    public ColumnDefinition setName(ByteBuffer name) {
        this.columnDef.setName(name.duplicate());
        return this;
    }

    @Override
    public ColumnDefinition setName(byte[] name) {
        this.columnDef.setName(name);
        return this;
    }

    @Override
    public ColumnDefinition setValidationClass(String value) {
        this.columnDef.setValidation_class(value);
        return this;
    }

    @Override
    public String getName() {
        return StringSerializer.get().fromByteBuffer(this.getRawName().duplicate());
    }

    @Override
    public String getValidationClass() {
        return this.columnDef.getValidation_class();
    }

    @Override
    public ByteBuffer getRawName() {
        return ByteBuffer.wrap(this.columnDef.getName());
    }

    @Override
    public String getIndexName() {
        return this.columnDef.getIndex_name();
    }

    @Override
    public String getIndexType() {
        return this.columnDef.getIndex_type() == null ? null : this.columnDef.getIndex_type().name();
    }

    @Override
    public boolean hasIndex() {
        return this.columnDef.getIndex_type() != null;
    }

    @Override
    public ColumnDefinition setIndex(String name, String type) {
        this.columnDef.setIndex_name(name);
        this.columnDef.setIndex_type(IndexType.valueOf((String)type));
        return this;
    }

    @Override
    public ColumnDefinition setKeysIndex(String name) {
        this.columnDef.setIndex_name(name);
        this.columnDef.setIndex_type(IndexType.KEYS);
        return this;
    }

    @Override
    public String getOption(String name, String defaultValue) {
        String value;
        if (this.columnDef != null && this.columnDef.getIndex_options() != null && (value = (String)this.columnDef.getIndex_options().get(name)) != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public String setOption(String name, String value) {
        if (this.columnDef.getIndex_options() == null) {
            this.columnDef.setIndex_options(new HashMap());
        }
        return this.columnDef.getIndex_options().put(name, value);
    }

    @Override
    public Collection<String> getFieldNames() {
        return fieldsMetadata.keySet();
    }

    @Override
    public Object getFieldValue(String name) {
        return this.columnDef.getFieldValue(ColumnDef._Fields.valueOf((String)name));
    }

    @Override
    public ColumnDefinition setFieldValue(String name, Object value) {
        this.columnDef.setFieldValue(ColumnDef._Fields.valueOf((String)name), value);
        return this;
    }

    @Override
    public Collection<FieldMetadata> getFieldsMetadata() {
        return fieldsMetadata.values();
    }

    @Override
    public ColumnDefinition setFields(Map<String, Object> options) {
        for (Map.Entry<String, FieldMetadata> field : fieldsMetadata.entrySet()) {
            String fieldName = field.getKey();
            if (!options.containsKey(fieldName)) continue;
            if ("index_type".equals(fieldName)) {
                this.setFieldValue(field.getValue().getName(), IndexType.valueOf((String)options.get(fieldName).toString()));
                continue;
            }
            this.setFieldValue(field.getValue().getName(), options.get(fieldName));
        }
        return this;
    }

    static {
        for (Map.Entry field : ColumnDef.metaDataMap.entrySet()) {
            fieldsMetadata.put(((FieldMetaData)field.getValue()).fieldName, new FieldMetadata(((ColumnDef._Fields)field.getKey()).name(), ThriftTypes.values()[((FieldMetaData)field.getValue()).valueMetaData.type].name(), ((FieldMetaData)field.getValue()).valueMetaData.isContainer()));
        }
    }
}

