/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.uniqueness;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.recipes.uniqueness.NotUniqueException;
import com.netflix.astyanax.recipes.uniqueness.UniquenessConstraint;
import com.netflix.astyanax.serializers.StringSerializer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class RowUniquenessConstraint<K, C>
implements UniquenessConstraint {
    private final ColumnFamily<K, C> columnFamily;
    private final Keyspace keyspace;
    private final C uniqueColumn;
    private final K key;
    private ConsistencyLevel consistencyLevel = ConsistencyLevel.CL_LOCAL_QUORUM;
    private ByteBuffer data = null;
    private Integer ttl = null;

    public RowUniquenessConstraint(Keyspace keyspace, ColumnFamily<K, C> columnFamily, K key, Supplier<C> uniqueColumnSupplier) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.uniqueColumn = uniqueColumnSupplier.get();
        this.key = key;
    }

    public RowUniquenessConstraint<K, C> withTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    public RowUniquenessConstraint<K, C> withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public RowUniquenessConstraint<K, C> withData(ByteBuffer data) {
        this.data = data;
        return this;
    }

    public RowUniquenessConstraint<K, C> withData(String data) {
        this.data = StringSerializer.get().fromString(data);
        return this;
    }

    @Override
    public void acquire() throws NotUniqueException, Exception {
        this.acquireAndApplyMutation(null);
    }

    @Override
    @Deprecated
    public void acquireAndMutate(final MutationBatch mutation) throws NotUniqueException, Exception {
        this.acquireAndApplyMutation(new Function<MutationBatch, Boolean>(){

            public Boolean apply(@Nullable MutationBatch input) {
                if (mutation != null) {
                    input.mergeShallow(mutation);
                }
                return true;
            }
        });
    }

    @Override
    public void acquireAndApplyMutation(Function<MutationBatch, Boolean> callback) throws NotUniqueException, Exception {
        try {
            MutationBatch m = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
            if (this.data == null) {
                m.withRow(this.columnFamily, this.key).putEmptyColumn(this.uniqueColumn, this.ttl);
            } else {
                m.withRow(this.columnFamily, this.key).putColumn(this.uniqueColumn, this.data, this.ttl);
            }
            m.execute();
            ColumnList result = (ColumnList)this.keyspace.prepareQuery(this.columnFamily).setConsistencyLevel(this.consistencyLevel).getKey(this.key).execute().getResult();
            if (result.size() != 1) {
                throw new NotUniqueException(this.key.toString());
            }
            m = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
            if (callback != null) {
                callback.apply((Object)m);
            }
            if (this.data == null) {
                m.withRow(this.columnFamily, this.key).putEmptyColumn(this.uniqueColumn, null);
            } else {
                m.withRow(this.columnFamily, this.key).putColumn(this.uniqueColumn, this.data, null);
            }
            m.execute();
        }
        catch (Exception e) {
            this.release();
            throw e;
        }
    }

    @Override
    public void release() throws Exception {
        MutationBatch m = this.keyspace.prepareMutationBatch().setConsistencyLevel(this.consistencyLevel);
        m.withRow(this.columnFamily, this.key).deleteColumn(this.uniqueColumn);
        m.execute();
    }

    public ByteBuffer readData() throws Exception {
        ColumnList result = (ColumnList)this.keyspace.prepareQuery(this.columnFamily).setConsistencyLevel(this.consistencyLevel).getKey(this.key).execute().getResult();
        boolean hasColumn = false;
        ByteBuffer data = null;
        for (Column column : result) {
            if (column.getTtl() != 0) continue;
            if (hasColumn) {
                throw new IllegalStateException("Row has multiple uniquneness locks");
            }
            hasColumn = true;
            data = column.getByteBufferValue();
        }
        if (!hasColumn) {
            throw new NotFoundException(this.key.toString() + " has no uniquness lock");
        }
        return data;
    }

    public String readDataAsString() throws Exception {
        return StringSerializer.get().fromByteBuffer(this.readData());
    }
}

