/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import com.netflix.astyanax.annotations.Component;
import com.netflix.astyanax.recipes.queue.MessageMetadataEntryType;
import com.netflix.astyanax.util.TimeUUIDUtils;

public class MessageMetadataEntry {
    @Component(ordinal=0)
    private Byte type;
    @Component(ordinal=1)
    private String name;

    public MessageMetadataEntry() {
    }

    public MessageMetadataEntry(MessageMetadataEntryType type, String name) {
        this.type = (byte)type.ordinal();
        this.name = name;
    }

    public Byte getType() {
        return this.type;
    }

    public MessageMetadataEntryType getMetadataType() {
        return MessageMetadataEntryType.values()[this.type];
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static MessageMetadataEntry newMessageId(String messageId) {
        return new MessageMetadataEntry(MessageMetadataEntryType.MessageId, messageId);
    }

    public static MessageMetadataEntry newField(String name) {
        return new MessageMetadataEntry(MessageMetadataEntryType.Field, name);
    }

    public static MessageMetadataEntry newUnique() {
        return new MessageMetadataEntry(MessageMetadataEntryType.Unique, TimeUUIDUtils.getUniqueTimeUUIDinMicros().toString());
    }

    public static MessageMetadataEntry newLock() {
        return new MessageMetadataEntry(MessageMetadataEntryType.Unique, TimeUUIDUtils.getUniqueTimeUUIDinMicros().toString());
    }

    public String toString() {
        return "MessageMetadata [type=" + this.type + ", name=" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageMetadataEntry other = (MessageMetadataEntry)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

