/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.SerializerTypeInferer;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;

class EntityAnnotation {
    private final Class<?> clazz;
    private final Field idField;
    private final ImmutableMap<String, ColumnMapper> columnMappers;

    EntityAnnotation(Class<?> clazz) {
        this.clazz = clazz;
        Field tmpIdField = null;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet usedColumnNames = Sets.newHashSet();
        for (Field field : clazz.getDeclaredFields()) {
            Id idAnnotation = field.getAnnotation(Id.class);
            Column columnAnnotation = field.getAnnotation(Column.class);
            if (idAnnotation != null && columnAnnotation != null) {
                throw new IllegalArgumentException("field cannot be marked as both an Id and a Column: " + field.getName());
            }
            if (idAnnotation != null) {
                Preconditions.checkArgument((tmpIdField == null ? 1 : 0) != 0, (Object)"there are multiple fields with @Id annotation");
                field.setAccessible(true);
                tmpIdField = field;
            }
            if (columnAnnotation == null) continue;
            String columnName = this.getColumnName(columnAnnotation, field);
            Preconditions.checkArgument((!usedColumnNames.contains(columnName) ? 1 : 0) != 0, (Object)String.format("duplicate case-insensitive column name: %s", columnName));
            usedColumnNames.add(columnName);
            field.setAccessible(true);
            Serializer serializer = SerializerTypeInferer.getSerializer(field.getType());
            builder.put((Object)columnName, (Object)new ColumnMapper(field, serializer));
        }
        Preconditions.checkNotNull(tmpIdField, (Object)"there are no field with @Id annotation");
        this.idField = tmpIdField;
        this.columnMappers = builder.build();
    }

    private String getColumnName(Column annotation, Field field) {
        String name = annotation.name().isEmpty() ? field.getName() : annotation.name();
        return name.toLowerCase();
    }

    Field getId() {
        return this.idField;
    }

    Map<String, ColumnMapper> getColumnMappers() {
        return this.columnMappers;
    }

    public String toString() {
        return String.format("EntityMapper(%s)", this.clazz);
    }

    static class ColumnMapper {
        private final Field field;
        private final Serializer<?> serializer;

        ColumnMapper(Field field, Serializer<?> serializer) {
            this.field = field;
            this.serializer = serializer;
        }

        Field getField() {
            return this.field;
        }

        Serializer<?> getSerializer() {
            return this.serializer;
        }
    }
}

