/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.IntegerArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import com.lowagie.toolbox.swing.PdfInformationPanel;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class Split
extends AbstractTool {
    public Split() {
        FileArgument f = new FileArgument(this, "srcfile", "The file you want to split", false, new PdfFilter());
        f.setLabel(new PdfInformationPanel());
        this.arguments.add(f);
        this.arguments.add(new FileArgument(this, "destfile1", "The file to which the first part of the original PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile2", "The file to which the second part of the original PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new IntegerArgument(this, "pagenumber", "The pagenumber where you want to split"));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Split", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Split OPENED ===");
    }

    public void execute() {
        try {
            int rotation;
            PdfImportedPage page;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile1") == null) {
                throw new InstantiationException("You need to choose a destination file for the first part of the PDF");
            }
            File file1 = (File)this.getValue("destfile1");
            if (this.getValue("destfile2") == null) {
                throw new InstantiationException("You need to choose a destination file for the second part of the PDF");
            }
            File file2 = (File)this.getValue("destfile2");
            int pagenumber = Integer.parseInt((String)this.getValue("pagenumber"));
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int n = reader.getNumberOfPages();
            System.out.println("There are " + n + " pages in the original file.");
            if (pagenumber < 2 || pagenumber > n) {
                throw new DocumentException("You can't split this document at page " + pagenumber + "; there is no such page.");
            }
            Document document1 = new Document(reader.getPageSizeWithRotation(1));
            Document document2 = new Document(reader.getPageSizeWithRotation(pagenumber));
            PdfWriter writer1 = PdfWriter.getInstance(document1, new FileOutputStream(file1));
            PdfWriter writer2 = PdfWriter.getInstance(document2, new FileOutputStream(file2));
            document1.open();
            PdfContentByte cb1 = writer1.getDirectContent();
            document2.open();
            PdfContentByte cb2 = writer2.getDirectContent();
            int i = 0;
            while (i < pagenumber - 1) {
                document1.setPageSize(reader.getPageSizeWithRotation(++i));
                document1.newPage();
                page = writer1.getImportedPage(reader, i);
                rotation = reader.getPageRotation(i);
                if (rotation == 90 || rotation == 270) {
                    cb1.addTemplate(page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, reader.getPageSizeWithRotation(i).getHeight());
                    continue;
                }
                cb1.addTemplate(page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            while (i < n) {
                document2.setPageSize(reader.getPageSizeWithRotation(++i));
                document2.newPage();
                page = writer2.getImportedPage(reader, i);
                rotation = reader.getPageRotation(i);
                if (rotation == 90 || rotation == 270) {
                    cb2.addTemplate(page, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, reader.getPageSizeWithRotation(i).getHeight());
                    continue;
                }
                cb2.addTemplate(page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            document1.close();
            document2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        Split tool = new Split();
        if (args.length < 4) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile1");
    }

    static {
        Split.addVersion("$Id: Split.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

