/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class ImageJ_Updater
implements PlugIn {
    public void run(String arg) {
        String msg;
        File file;
        String ij_jar;
        if (arg.equals("menus")) {
            this.updateMenus();
            return;
        }
        if (IJ.getApplet() != null) {
            return;
        }
        URL url = this.getClass().getResource("/ij/IJ.class");
        String string = ij_jar = url == null ? null : url.toString().replaceAll("%20", " ");
        if (ij_jar == null || !ij_jar.startsWith("jar:file:")) {
            this.error("Could not determine location of ij.jar");
            return;
        }
        int exclamation = ij_jar.indexOf(33);
        ij_jar = ij_jar.substring(9, exclamation);
        if (IJ.debugMode) {
            IJ.log("Updater: " + ij_jar);
        }
        if (!(file = new File(ij_jar)).exists()) {
            this.error("File not found: " + file.getPath());
            return;
        }
        if (!file.canWrite()) {
            String msg2 = "No write access: " + file.getPath();
            if (IJ.isVista()) {
                msg2 = msg2 + "\n \nOn Windows Vista, ImageJ must be installed in a directory that\nthe user can write to, such as \"Desktop\" or \"Documents\"";
            }
            this.error(msg2);
            return;
        }
        String[] list = this.openUrlAsList("http://imagej.nih.gov/ij/download/jars/list.txt");
        int count = list.length + 2;
        String[] versions = new String[count];
        String[] urls = new String[count];
        String uv = this.getUpgradeVersion();
        if (uv == null) {
            return;
        }
        versions[0] = "v" + uv;
        urls[0] = "http://imagej.nih.gov/ij/upgrade/ij.jar";
        if (versions[0] == null) {
            return;
        }
        for (int i = 1; i < count - 1; ++i) {
            String version = list[i - 1];
            versions[i] = version.substring(0, version.length() - 1);
            urls[i] = "http://imagej.nih.gov/ij/download/jars/ij" + version.substring(1, 2) + version.substring(3, 6) + ".jar";
        }
        versions[count - 1] = "daily build";
        urls[count - 1] = "http://imagej.nih.gov/ij/ij.jar";
        int choice = this.showDialog(versions);
        if (choice == -1) {
            return;
        }
        if (!versions[choice].startsWith("daily") && versions[choice].compareTo("v1.39") < 0 && Menus.getCommands().get("ImageJ Updater") == null && !IJ.showMessageWithCancel("Update ImageJ", msg = "This command is not available in versions of ImageJ prior\nto 1.39 so you will need to install the plugin version at\n<http://imagej.nih.gov/ij/plugins/imagej-updater.html>.")) {
            return;
        }
        byte[] jar = this.getJar(urls[choice]);
        if (jar == null) {
            this.error("Unable to download ij.jar from " + urls[choice]);
            return;
        }
        if (this.version().compareTo("1.37v") >= 0) {
            Prefs.savePreferences();
        }
        this.saveJar(file, jar);
        if (choice < count - 1) {
            new File(IJ.getDirectory("macros") + "functions.html").delete();
        }
        System.exit(0);
    }

    int showDialog(String[] versions) {
        GenericDialog gd = new GenericDialog("ImageJ Updater");
        gd.addChoice("Upgrade To:", versions, versions[0]);
        String msg = "You are currently running v" + this.version() + ".\n" + " \n" + "If you click \"OK\", ImageJ will quit\n" + "and you will be running the upgraded\n" + "version after you restart ImageJ.\n";
        gd.addMessage(msg);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return -1;
        }
        return gd.getNextChoiceIndex();
    }

    String getUpgradeVersion() {
        String url = "http://imagej.nih.gov/ij/notes.html";
        String notes = this.openUrlAsString(url, 20);
        if (notes == null) {
            this.error("Unable to connect to http://imagej.nih.gov/ij. You\nmay need to use the Edit>Options>Proxy Settings\ncommand to configure ImageJ to use a proxy server.");
            return null;
        }
        int index = notes.indexOf("Version ");
        if (index == -1) {
            this.error("Release notes are not in the expected format");
            return null;
        }
        String version = notes.substring(index + 8, index + 13);
        return version;
    }

    String openUrlAsString(String address, int maxLines) {
        StringBuffer sb;
        try {
            String line;
            URL url = new URL(address);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            sb = new StringBuffer();
            int count = 0;
            while ((line = br.readLine()) != null && count++ < maxLines) {
                sb.append(line + "\n");
            }
            in.close();
        }
        catch (IOException e) {
            sb = null;
        }
        return sb != null ? new String(sb) : null;
    }

    byte[] getJar(String address) {
        byte[] data;
        boolean gte133 = this.version().compareTo("1.33u") >= 0;
        try {
            int count;
            URL url = new URL(address);
            IJ.showStatus("Connecting to http://imagej.nih.gov/ij");
            URLConnection uc = url.openConnection();
            int len = uc.getContentLength();
            if (len <= 0) {
                return null;
            }
            String name = address.endsWith("ij/ij.jar") ? "daily build" : "ij.jar";
            IJ.showStatus("Downloading ij.jar (" + IJ.d2s((double)len / 1048576.0, 1) + "MB)");
            InputStream in = uc.getInputStream();
            data = new byte[len];
            for (int n = 0; n < len; n += count) {
                count = in.read(data, n, len - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
            in.close();
        }
        catch (IOException e) {
            return null;
        }
        return data;
    }

    void saveJar(File f, byte[] data) {
        try {
            FileOutputStream out = new FileOutputStream(f);
            out.write(data, 0, data.length);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String[] openUrlAsList(String address) {
        IJ.showStatus("Connecting to http://imagej.nih.gov/ij");
        Vector<String> v = new Vector<String>();
        try {
            String line;
            URL url = new URL(address);
            InputStream in = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if (line.equals("")) continue;
                v.addElement(line);
            }
            br.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        Object[] lines = new String[v.size()];
        v.copyInto(lines);
        IJ.showStatus("");
        return lines;
    }

    String version() {
        String version = "";
        try {
            Class<ImageJ> ijClass = ImageJ.class;
            Field field = ijClass.getField("VERSION");
            version = (String)field.get(ijClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    boolean isMac() {
        String osname = System.getProperty("os.name");
        return osname.startsWith("Mac");
    }

    void error(String msg) {
        IJ.error("ImageJ Updater", msg);
    }

    void updateMenus() {
        if (IJ.debugMode) {
            long start = System.currentTimeMillis();
            Menus.updateImageJMenus();
            IJ.log("Refresh Menus: " + (System.currentTimeMillis() - start) + " ms");
        } else {
            Menus.updateImageJMenus();
        }
    }
}

