/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class PluginClassLoader
extends URLClassLoader {
    protected String path;

    public PluginClassLoader(String path) {
        super(new URL[0], IJ.class.getClassLoader());
        this.init(path);
    }

    public PluginClassLoader(String path, boolean callSuper) {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        this.init(path);
    }

    void init(String path) {
        this.path = path;
        File f = new File(path);
        try {
            this.addURL(f.toURI().toURL());
        }
        catch (MalformedURLException e) {
            IJ.log("PluginClassLoader: " + e);
        }
        String[] list = f.list();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].equals(".rsrc")) continue;
            f = new File(path, list[i]);
            if (f.isDirectory()) {
                try {
                    this.addURL(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    IJ.log("PluginClassLoader: " + e);
                }
                String[] innerlist = f.list();
                if (innerlist == null) continue;
                for (int j = 0; j < innerlist.length; ++j) {
                    File g = new File(f, innerlist[j]);
                    if (!g.isFile()) continue;
                    this.addJAR(g);
                }
                continue;
            }
            this.addJAR(f);
        }
    }

    private void addJAR(File f) {
        if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
            try {
                this.addURL(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                IJ.log("PluginClassLoader: " + e);
            }
        }
    }
}

