/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tml.proxies;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.gcube.common.clients.fw.queries.StatefulQuery;

public class SourceQueryBuilder {
    private final StatefulQuery query;
    private String id;
    private String name;
    private List<QName> types = new ArrayList<QName>();

    public SourceQueryBuilder(StatefulQuery query) {
        query.addNamespace("tm", URI.create("http://gcube-system.org/namespaces/data/tm"));
        this.query = query;
    }

    public SourceQueryBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public SourceQueryBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public SourceQueryBuilder withType(QName type) {
        this.types.add(type);
        return this;
    }

    public StatefulQuery build() {
        if (this.name != null) {
            this.query.addCondition("$resource/Data/tm:Name/text() eq '" + this.name + "'");
        }
        if (this.id != null) {
            this.query.addCondition("$resource/Data/tm:SourceId/text() eq '" + this.id + "'");
        }
        if (!this.types.isEmpty()) {
            this.query.addVariable("$type", "$resource/Data/tm:Type");
            for (QName type : this.types) {
                this.query.addCondition("resolve-QName($type/text(),$type) eq QName('" + type.getNamespaceURI() + "','" + type.getLocalPart() + "')");
            }
        }
        return this.query;
    }
}

