/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.gcube.common.core.utils.logging.GCUBELog;

public class ISCacheMM {
    private static MBeanServer mbs = null;
    private static GCUBELog log = new GCUBELog(ISCacheMM.class);

    public static void registerISMBean(String name, Object beanObj) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        try {
            ObjectName nameObj = new ObjectName(name);
            mbs.registerMBean(beanObj, nameObj);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)e);
            throw new MalformedObjectNameException(e.getMessage());
        }
        catch (NullPointerException e) {
            log.error((Object)e);
            throw new NullPointerException(e.getMessage());
        }
    }

    public static void unregisterISMBean(String name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, InstanceNotFoundException {
        try {
            ObjectName nameObj = new ObjectName(name);
            mbs.unregisterMBean(nameObj);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)e);
            throw new MalformedObjectNameException(e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            log.error((Object)e);
            throw new InstanceNotFoundException(e.getMessage());
        }
    }

    private static void initMBeanServer() {
        mbs = ManagementFactory.getPlatformMBeanServer();
    }

    public static void init() {
        if (mbs == null) {
            ISCacheMM.initMBeanServer();
        }
    }
}

