/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.MappedFileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmappedSegmentedFile
extends SegmentedFile {
    private static final Logger logger = LoggerFactory.getLogger(MmappedSegmentedFile.class);
    public static long MAX_SEGMENT_SIZE = Integer.MAX_VALUE;
    private static Method cleanerMethod = null;
    private final SegmentedFile.Segment[] segments;

    public MmappedSegmentedFile(String path, long length, SegmentedFile.Segment[] segments) {
        super(path, length);
        this.segments = segments;
    }

    private SegmentedFile.Segment floor(long position) {
        assert (0L <= position && position < this.length) : position + " vs " + this.length;
        SegmentedFile.Segment seg = new SegmentedFile.Segment(position, null);
        int idx = Arrays.binarySearch(this.segments, seg);
        assert (idx != -1) : "Bad position " + position + " in segments " + Arrays.toString(this.segments);
        if (idx < 0) {
            idx = -(idx + 2);
        }
        return this.segments[idx];
    }

    @Override
    public FileDataInput getSegment(long position) {
        SegmentedFile.Segment segment = this.floor(position);
        if (segment.right != null) {
            return new MappedFileDataInput((MappedByteBuffer)segment.right, this.path, (int)(position - (Long)segment.left));
        }
        try {
            RandomAccessReader file = RandomAccessReader.open(new File(this.path));
            file.seek(position);
            return file;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static void initCleaner() {
        try {
            cleanerMethod = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
        }
        catch (Exception e) {
            logger.info("Cannot initialize un-mmaper.  (Are you using a non-SUN JVM?)  Compacted data files will not be removed promptly.  Consider using a SUN JVM or using standard disk access mode");
        }
    }

    public static boolean isCleanerAvailable() {
        return cleanerMethod != null;
    }

    @Override
    public void cleanup() {
        if (cleanerMethod == null) {
            return;
        }
        try {
            for (SegmentedFile.Segment segment : this.segments) {
                if (segment.right == null) continue;
                Object cleaner = cleanerMethod.invoke(segment.right, new Object[0]);
                cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
            }
            logger.debug("All segments have been unmapped successfully");
        }
        catch (Exception e) {
            logger.error("Error while unmapping segments", (Throwable)e);
        }
    }

    static class Builder
    extends SegmentedFile.Builder {
        private final List<Long> boundaries = new ArrayList<Long>();
        private long currentStart = 0L;
        private long currentSize = 0L;

        public Builder() {
            this.boundaries.add(0L);
        }

        @Override
        public void addPotentialBoundary(long boundary) {
            if (boundary - this.currentStart <= MAX_SEGMENT_SIZE) {
                this.currentSize = boundary - this.currentStart;
                return;
            }
            if (this.currentSize > 0L) {
                this.currentStart += this.currentSize;
                this.boundaries.add(this.currentStart);
            }
            this.currentSize = boundary - this.currentStart;
            if (this.currentSize > MAX_SEGMENT_SIZE) {
                this.currentStart = boundary;
                this.boundaries.add(this.currentStart);
                this.currentSize = 0L;
            }
        }

        @Override
        public SegmentedFile complete(String path) {
            long length = new File(path).length();
            this.boundaries.add(length);
            return new MmappedSegmentedFile(path, length, this.createSegments(path));
        }

        private SegmentedFile.Segment[] createSegments(String path) {
            int segcount = this.boundaries.size() - 1;
            SegmentedFile.Segment[] segments = new SegmentedFile.Segment[segcount];
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(path, "r");
                for (int i = 0; i < segcount; ++i) {
                    long start = this.boundaries.get(i);
                    long size = this.boundaries.get(i + 1) - start;
                    MappedByteBuffer segment = size <= MAX_SEGMENT_SIZE ? raf.getChannel().map(FileChannel.MapMode.READ_ONLY, start, size) : null;
                    segments[i] = new SegmentedFile.Segment(start, segment);
                }
            }
            catch (IOException e) {
                try {
                    throw new IOError(e);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(raf);
                    throw throwable;
                }
            }
            FileUtils.closeQuietly(raf);
            return segments;
        }
    }
}

