/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.concurrent.atomic.AtomicLong;

public class BloomFilterTracker {
    private AtomicLong falsePositiveCount = new AtomicLong(0L);
    private AtomicLong truePositiveCount = new AtomicLong(0L);
    private long lastFalsePositiveCount = 0L;
    private long lastTruePositiveCount = 0L;

    public void addFalsePositive() {
        this.falsePositiveCount.incrementAndGet();
    }

    public void addTruePositive() {
        this.truePositiveCount.incrementAndGet();
    }

    public long getFalsePositiveCount() {
        return this.falsePositiveCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecentFalsePositiveCount() {
        long fpc = this.getFalsePositiveCount();
        try {
            long l = fpc - this.lastFalsePositiveCount;
            return l;
        }
        finally {
            this.lastFalsePositiveCount = fpc;
        }
    }

    public long getTruePositiveCount() {
        return this.truePositiveCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecentTruePositiveCount() {
        long tpc = this.getTruePositiveCount();
        try {
            long l = tpc - this.lastTruePositiveCount;
            return l;
        }
        finally {
            this.lastTruePositiveCount = tpc;
        }
    }
}

