/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.AbstractPartitioner;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Hex;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.ArrayUtils;

public abstract class AbstractByteOrderedPartitioner
extends AbstractPartitioner<BytesToken> {
    public static final BytesToken MINIMUM = new BytesToken(ArrayUtils.EMPTY_BYTE_ARRAY);
    public static final BigInteger BYTE_MASK = new BigInteger("255");
    private final Token.TokenFactory<byte[]> tokenFactory = new Token.TokenFactory<byte[]>(){

        @Override
        public ByteBuffer toByteArray(Token<byte[]> bytesToken) {
            return ByteBuffer.wrap((byte[])bytesToken.token);
        }

        @Override
        public Token<byte[]> fromByteArray(ByteBuffer bytes) {
            return new BytesToken(bytes);
        }

        @Override
        public String toString(Token<byte[]> bytesToken) {
            return Hex.bytesToHex((byte[])bytesToken.token);
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                if (token.length() % 2 == 1) {
                    token = "0" + token;
                }
                Hex.hexToBytes(token);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Token " + token + " contains non-hex digits");
            }
        }

        @Override
        public Token<byte[]> fromString(String string) {
            if (string.length() % 2 == 1) {
                string = "0" + string;
            }
            return new BytesToken(Hex.hexToBytes(string));
        }
    };

    @Override
    public DecoratedKey<BytesToken> decorateKey(ByteBuffer key) {
        return new DecoratedKey<BytesToken>(this.getToken(key), key);
    }

    @Override
    public DecoratedKey<BytesToken> convertFromDiskFormat(ByteBuffer key) {
        return new DecoratedKey<BytesToken>(this.getToken(key), key);
    }

    @Override
    public BytesToken midpoint(Token ltoken, Token rtoken) {
        ByteBuffer rb;
        int rl;
        ByteBuffer lb;
        int ll;
        if (ltoken.token instanceof byte[]) {
            ll = ((byte[])ltoken.token).length;
            lb = ByteBuffer.wrap((byte[])ltoken.token);
        } else {
            ll = ((ByteBuffer)ltoken.token).remaining();
            lb = (ByteBuffer)ltoken.token;
        }
        if (rtoken.token instanceof byte[]) {
            rl = ((byte[])rtoken.token).length;
            rb = ByteBuffer.wrap((byte[])rtoken.token);
        } else {
            rl = ((ByteBuffer)rtoken.token).remaining();
            rb = (ByteBuffer)rtoken.token;
        }
        int sigbytes = Math.max(ll, rl);
        BigInteger left = this.bigForBytes(lb, sigbytes);
        BigInteger right = this.bigForBytes(rb, sigbytes);
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 8 * sigbytes);
        return new BytesToken(this.bytesForBig((BigInteger)midpair.left, sigbytes, (Boolean)midpair.right));
    }

    private BigInteger bigForBytes(ByteBuffer bytes, int sigbytes) {
        byte[] b = new byte[sigbytes];
        Arrays.fill(b, (byte)0);
        ByteBufferUtil.arrayCopy(bytes, bytes.position(), b, 0, bytes.remaining());
        return new BigInteger(1, b);
    }

    private byte[] bytesForBig(BigInteger big, int sigbytes, boolean remainder) {
        byte[] bytes = new byte[sigbytes + (remainder ? 1 : 0)];
        if (remainder) {
            int n = sigbytes;
            bytes[n] = (byte)(bytes[n] | 0x80);
        }
        for (int i = 0; i < sigbytes; ++i) {
            int maskpos = 8 * (sigbytes - (i + 1));
            bytes[i] = (byte)(big.and(BYTE_MASK.shiftLeft(maskpos)).shiftRight(maskpos).intValue() & 0xFF);
        }
        return bytes;
    }

    @Override
    public BytesToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BytesToken getRandomToken() {
        Random r = new Random();
        byte[] buffer = new byte[16];
        r.nextBytes(buffer);
        return new BytesToken(buffer);
    }

    @Override
    public Token.TokenFactory<byte[]> getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public abstract BytesToken getToken(ByteBuffer var1);

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> allTokens = new HashMap<Token, Float>();
        ArrayList<Range<Token>> sortedRanges = new ArrayList<Range<Token>>();
        Token lastToken = sortedTokens.get(sortedTokens.size() - 1);
        for (Token node : sortedTokens) {
            allTokens.put(node, new Float(0.0));
            sortedRanges.add(new Range<Token>(lastToken, node));
            lastToken = node;
        }
        for (String ks : Schema.instance.getTables()) {
            for (CFMetaData cfmd : Schema.instance.getKSMetaData(ks).cfMetaData().values()) {
                for (Range range : sortedRanges) {
                    allTokens.put((Token)range.right, Float.valueOf(((Float)allTokens.get(range.right)).floatValue() + (float)StorageService.instance.getSplits(ks, cfmd.cfName, range, 1).size()));
                }
            }
        }
        Float total = new Float(0.0);
        for (Float f : allTokens.values()) {
            total = Float.valueOf(total.floatValue() + f.floatValue());
        }
        for (Map.Entry entry : allTokens.entrySet()) {
            allTokens.put((Token)entry.getKey(), Float.valueOf(((Float)entry.getValue()).floatValue() / total.floatValue()));
        }
        return allTokens;
    }
}

