/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

class SliceByNamesReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    SliceByNamesReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand cmd, DataOutput dos, int version) throws IOException {
        SliceByNamesReadCommand command = (SliceByNamesReadCommand)cmd;
        dos.writeBoolean(command.isDigestQuery());
        dos.writeUTF(command.table);
        ByteBufferUtil.writeWithShortLength(command.key, dos);
        command.queryPath.serialize(dos);
        dos.writeInt(command.columnNames.size());
        if (!command.columnNames.isEmpty()) {
            for (ByteBuffer cName : command.columnNames) {
                ByteBufferUtil.writeWithShortLength(cName, dos);
            }
        }
    }

    @Override
    public SliceByNamesReadCommand deserialize(DataInput dis, int version) throws IOException {
        boolean isDigest = dis.readBoolean();
        String table = dis.readUTF();
        ByteBuffer key = ByteBufferUtil.readWithShortLength(dis);
        QueryPath columnParent = QueryPath.deserialize(dis);
        int size = dis.readInt();
        ArrayList<ByteBuffer> columns = new ArrayList<ByteBuffer>();
        for (int i = 0; i < size; ++i) {
            columns.add(ByteBufferUtil.readWithShortLength(dis));
        }
        SliceByNamesReadCommand command = new SliceByNamesReadCommand(table, key, columnParent, columns);
        command.setDigestQuery(isDigest);
        return command;
    }

    @Override
    public long serializedSize(ReadCommand cmd, int version) {
        SliceByNamesReadCommand command = (SliceByNamesReadCommand)cmd;
        int size = 1;
        size += 2 + FBUtilities.encodedUTF8Length(command.table);
        size += 2 + command.key.remaining();
        size += command.queryPath.serializedSize();
        size += 4;
        if (!command.columnNames.isEmpty()) {
            for (ByteBuffer cName : command.columnNames) {
                size += 2 + cName.remaining();
            }
        }
        return size;
    }
}

