/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Symbol;
import ij.macro.Variable;
import java.util.Hashtable;

public class Program
implements MacroConstants {
    private int maxSymbols = 800;
    private int maxProgramSize = 2000;
    private int pc = -1;
    int stLoc = -1;
    int symTabLoc;
    Symbol[] table = new Symbol[this.maxSymbols];
    static Symbol[] systemTable;
    int[] code = new int[this.maxProgramSize];
    int[] lineNumbers = new int[this.maxProgramSize];
    Variable[] globals;
    boolean hasVars;
    boolean hasFunctions;
    int macroCount;
    Hashtable menus;
    boolean queueCommands;
    Hashtable extensionRegistry;

    public Program() {
        if (systemTable != null) {
            this.stLoc = systemTable.length - 1;
            for (int i = 0; i <= this.stLoc; ++i) {
                this.table[i] = systemTable[i];
            }
        } else {
            this.addKeywords();
            this.addFunctions();
            this.addNumericFunctions();
            this.addStringFunctions();
            this.addArrayFunctions();
            systemTable = new Symbol[this.stLoc + 1];
            for (int i = 0; i <= this.stLoc; ++i) {
                Program.systemTable[i] = this.table[i];
            }
            IJ.register(Program.class);
        }
    }

    public int[] getCode() {
        return this.code;
    }

    public Symbol[] getSymbolTable() {
        return this.table;
    }

    void addKeywords() {
        for (int i = 0; i < keywords.length; ++i) {
            this.addSymbol(new Symbol(keywordIDs[i], keywords[i]));
        }
    }

    void addFunctions() {
        for (int i = 0; i < functions.length; ++i) {
            this.addSymbol(new Symbol(functionIDs[i], functions[i]));
        }
    }

    void addNumericFunctions() {
        for (int i = 0; i < numericFunctions.length; ++i) {
            this.addSymbol(new Symbol(numericFunctionIDs[i], numericFunctions[i]));
        }
    }

    void addStringFunctions() {
        for (int i = 0; i < stringFunctions.length; ++i) {
            this.addSymbol(new Symbol(stringFunctionIDs[i], stringFunctions[i]));
        }
    }

    void addArrayFunctions() {
        for (int i = 0; i < arrayFunctions.length; ++i) {
            this.addSymbol(new Symbol(arrayFunctionIDs[i], arrayFunctions[i]));
        }
    }

    void addSymbol(Symbol sym) {
        ++this.stLoc;
        if (this.stLoc == this.table.length) {
            Symbol[] tmp = new Symbol[this.maxSymbols * 2];
            System.arraycopy(this.table, 0, tmp, 0, this.maxSymbols);
            this.table = tmp;
            this.maxSymbols *= 2;
        }
        this.table[this.stLoc] = sym;
    }

    void addToken(int tok, int lineNumber) {
        ++this.pc;
        if (this.pc == this.code.length) {
            int[] tmp = new int[this.maxProgramSize * 2];
            System.arraycopy(this.code, 0, tmp, 0, this.maxProgramSize);
            this.code = tmp;
            tmp = new int[this.maxProgramSize * 2];
            System.arraycopy(this.lineNumbers, 0, tmp, 0, this.maxProgramSize);
            this.lineNumbers = tmp;
            this.maxProgramSize *= 2;
        }
        this.code[this.pc] = tok;
        this.lineNumbers[this.pc] = lineNumber;
    }

    Symbol lookupWord(String str) {
        for (int i = 0; i <= this.stLoc; ++i) {
            Symbol symbol = this.table[i];
            if (symbol.type == 133 || !str.equals(symbol.str)) continue;
            this.symTabLoc = i;
            return symbol;
        }
        return null;
    }

    void saveGlobals(Interpreter interp) {
        if (interp.topOfStack == -1) {
            return;
        }
        int n = interp.topOfStack + 1;
        this.globals = new Variable[n];
        for (int i = 0; i < n; ++i) {
            this.globals[i] = interp.stack[i];
        }
    }

    public void dumpSymbolTable() {
        Symbol symbol;
        IJ.log("");
        IJ.log("Symbol Table");
        for (int i = 0; i <= this.maxSymbols && (symbol = this.table[i]) != null; ++i) {
            IJ.log(i + " " + symbol);
        }
    }

    public void dumpProgram() {
        IJ.log("");
        IJ.log("Tokenized Program");
        for (int i = 0; i <= this.pc; ++i) {
            IJ.log(i + "\t " + this.lineNumbers[i] + "   " + (this.code[i] & 0xFFF) + "   " + this.decodeToken(this.code[i]));
        }
    }

    public Variable[] getGlobals() {
        return this.globals;
    }

    public boolean hasVars() {
        return this.hasVars;
    }

    public int macroCount() {
        return this.macroCount;
    }

    public String decodeToken(int token) {
        return this.decodeToken(token & 0xFFF, token >> 12);
    }

    String decodeToken(int token, int address) {
        String str;
        block0 : switch (token) {
            case 129: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                str = this.table[address].str;
                break;
            }
            case 133: {
                str = "\"" + this.table[address].str + "\"";
                break;
            }
            case 130: {
                double v = this.table[address].value;
                if ((double)((int)v) == v) {
                    str = IJ.d2s(v, 0);
                    break;
                }
                str = "" + v;
                break;
            }
            case 128: {
                str = "EOF";
                break;
            }
            default: {
                if (token < 32) {
                    switch (token) {
                        case 1: {
                            str = "++";
                            break block0;
                        }
                        case 2: {
                            str = "--";
                            break block0;
                        }
                        case 9: {
                            str = "+=";
                            break block0;
                        }
                        case 10: {
                            str = "-=";
                            break block0;
                        }
                        case 11: {
                            str = "*=";
                            break block0;
                        }
                        case 12: {
                            str = "/=";
                            break block0;
                        }
                        case 13: {
                            str = "&&";
                            break block0;
                        }
                        case 14: {
                            str = "||";
                            break block0;
                        }
                        case 3: {
                            str = "==";
                            break block0;
                        }
                        case 4: {
                            str = "!=";
                            break block0;
                        }
                        case 5: {
                            str = ">";
                            break block0;
                        }
                        case 6: {
                            str = ">=";
                            break block0;
                        }
                        case 7: {
                            str = "<";
                            break block0;
                        }
                        case 8: {
                            str = "<=";
                            break block0;
                        }
                    }
                    str = "";
                    break;
                }
                if (token >= 200) {
                    str = this.table[address].str;
                    break;
                }
                char[] s = new char[]{(char)token};
                str = new String(s);
            }
        }
        return str;
    }

    public Hashtable getMenus() {
        return this.menus;
    }

    public boolean hasWord(String word) {
        for (int i = 0; i < this.code.length; ++i) {
            int token = this.code[i];
            if (token <= 127) continue;
            if (token == 128) {
                return false;
            }
            int tokenAddress = token >> 12;
            String str = this.table[tokenAddress].str;
            if (str == null || !str.equals(word)) continue;
            return true;
        }
        return false;
    }
}

