/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.cache;

import java.net.URL;
import java.util.HashMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.gcube.application.framework.core.cache.factories.GenericResourceCacheEntryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachesManager {
    protected static CachesManager cacheManager = new CachesManager();
    protected CacheManager manager = CacheManager.create((URL)CachesManager.class.getResource("/ehcache.xml"));
    protected HashMap<String, Ehcache> caches = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(CachesManager.class);

    protected CachesManager() {
        Ehcache genericResourceCache = this.manager.getEhcache("genericResources");
        genericResourceCache = new SelfPopulatingCache(genericResourceCache, (CacheEntryFactory)new GenericResourceCacheEntryFactory());
        this.caches.put("genericResourceCache", genericResourceCache);
    }

    public static CachesManager getInstance() {
        return cacheManager;
    }

    public Ehcache getEhcache(String cacheName, CacheEntryFactory cacheFactory) {
        if (this.caches.get(cacheName) == null) {
            logger.debug("Didn't find any previous cache for " + cacheName + ". Creating a new and returning that.");
            Ehcache newCache = this.manager.getEhcache(cacheName);
            newCache = new SelfPopulatingCache(newCache, cacheFactory);
            this.caches.put(cacheName, newCache);
        }
        return this.caches.get(cacheName);
    }

    public Ehcache getGenericResourceCache() {
        return this.caches.get("genericResourceCache");
    }
}

