/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import jodd.io.FileChangeListener;

public class FileMonitor {
    protected Timer timer;
    protected final HashMap<File, Long> files = new HashMap();
    protected final Collection<FileChangeListener> listeners = new HashSet<FileChangeListener>();

    public FileMonitor(long pollingInterval) {
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new FileMonitorNotifier(), 0L, pollingInterval);
    }

    public void stop() {
        this.timer.cancel();
    }

    public void monitorFile(File file) {
        if (!this.files.containsKey(file)) {
            long modifiedTime = file.exists() ? file.lastModified() : -1L;
            this.files.put(file, new Long(modifiedTime));
        }
    }

    public void releaseFile(File file) {
        this.files.remove(file);
    }

    public void registerListener(FileChangeListener fileChangeListener) {
        for (FileChangeListener listener : this.listeners) {
            if (listener != fileChangeListener) continue;
            return;
        }
        this.listeners.add(fileChangeListener);
    }

    public void removeListener(FileChangeListener fileChangeListener) {
        Iterator<FileChangeListener> i = this.listeners.iterator();
        while (i.hasNext()) {
            FileChangeListener listener = i.next();
            if (listener != fileChangeListener) continue;
            i.remove();
            break;
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    protected class FileMonitorNotifier
    extends TimerTask {
        protected FileMonitorNotifier() {
        }

        public void run() {
            for (File file : FileMonitor.this.files.keySet()) {
                long lastModifiedTime = FileMonitor.this.files.get(file);
                long newModifiedTime = file.exists() ? file.lastModified() : -1L;
                if (newModifiedTime == lastModifiedTime) continue;
                FileMonitor.this.files.put(file, new Long(newModifiedTime));
                for (FileChangeListener listener : FileMonitor.this.listeners) {
                    listener.onFileChange(file);
                }
            }
        }
    }
}

