/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security;

import org.apache.abdera.Abdera;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.Signature;
import org.apache.abdera.util.Configuration;
import org.apache.abdera.util.ServiceUtil;

public class AbderaSecurity {
    private final Abdera abdera;
    private final Encryption encryption;
    private final Signature signature;

    public AbderaSecurity() {
        this(new Abdera());
    }

    public AbderaSecurity(Abdera abdera) {
        this.abdera = abdera;
        this.encryption = this.newEncryption();
        this.signature = this.newSignature();
    }

    public AbderaSecurity(Configuration config) {
        this(new Abdera(config));
    }

    private Abdera getAbdera() {
        return this.abdera;
    }

    public Encryption newEncryption() {
        return (Encryption)ServiceUtil.newInstance("org.apache.abdera.security.Encryption", "org.apache.abdera.security.xmlsec.XmlEncryption", this.getAbdera());
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public Signature newSignature() {
        return (Signature)ServiceUtil.newInstance("org.apache.abdera.security.Signature", "org.apache.abdera.security.xmlsec.XmlSignature", this.getAbdera());
    }

    public Signature getSignature() {
        return this.signature;
    }
}

