/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.serializer.impl;

import java.lang.reflect.AccessibleObject;
import javax.xml.namespace.QName;
import org.apache.abdera.ext.serializer.Conventions;
import org.apache.abdera.ext.serializer.ObjectContext;
import org.apache.abdera.ext.serializer.SerializationContext;
import org.apache.abdera.ext.serializer.annotation.Text;
import org.apache.abdera.ext.serializer.annotation.Value;
import org.apache.abdera.ext.serializer.impl.ElementSerializer;
import org.apache.abdera.model.Div;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Text;
import org.apache.abdera.writer.StreamWriter;

public class TextSerializer
extends ElementSerializer {
    public TextSerializer(QName qname) {
        super(qname);
    }

    public TextSerializer() {
        super(null);
    }

    protected void init(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
    }

    protected void process(Object source, ObjectContext objectContext, SerializationContext context, Conventions conventions) {
        Text _text;
        Text.Type type = Text.Type.TEXT;
        Object contentValue = null;
        ObjectContext valueContext = null;
        AccessibleObject accessor = objectContext.getAccessor(Value.class, conventions);
        if (accessor != null && !(source instanceof Element)) {
            contentValue = TextSerializer.eval(accessor, source);
            valueContext = new ObjectContext(contentValue, source, accessor);
            _text = valueContext.getAnnotation(Text.class);
            type = _text != null ? _text.type() : type;
        } else {
            _text = objectContext.getAnnotation(Text.class);
            type = _text != null ? _text.type() : type;
            contentValue = source;
            valueContext = objectContext;
        }
        QName qname = this.qname != null ? this.qname : TextSerializer.getQName(objectContext.getAccessor());
        StreamWriter sw = context.getStreamWriter();
        sw.startText(qname, type);
        this.writeAttributes(source, objectContext, context, conventions);
        switch (type) {
            case TEXT: 
            case HTML: {
                sw.writeElementText(TextSerializer.toString(contentValue));
                break;
            }
            case XHTML: {
                Div div = null;
                if (contentValue instanceof Div) {
                    div = (Div)contentValue;
                } else {
                    div = context.getAbdera().getFactory().newDiv();
                    div.setValue(TextSerializer.toString(contentValue));
                }
                context.serialize((Object)div, new ObjectContext(div));
            }
        }
    }
}

