/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class WikiIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{WikiPage.class.getName()};
    public static final String PORTLET_ID = "36";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("content"), (int)200);
        }
        String nodeId = document.get("nodeId");
        portletURL.setParameter("struts_action", "/wiki/view");
        portletURL.setParameter("nodeId", nodeId);
        portletURL.setParameter("title", title);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            long companyId = (Long)array[0];
            long nodeId = (Long)array[1];
            String title = (String)array[2];
            DocumentImpl document = new DocumentImpl();
            document.addUID(PORTLET_ID, nodeId, title);
            SearchEngineUtil.deleteDocument((long)companyId, (String)document.get("uid"));
        } else if (obj instanceof WikiNode) {
            WikiNode node = (WikiNode)obj;
            BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create();
            booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
            booleanQuery.addRequiredTerm("nodeId", node.getNodeId());
            Hits hits = SearchEngineUtil.search((long)node.getCompanyId(), (Query)booleanQuery, (int)-1, (int)-1);
            int i = 0;
            while (i < hits.getLength()) {
                Document document = hits.doc(i);
                SearchEngineUtil.deleteDocument((long)node.getCompanyId(), (String)document.get("uid"));
                ++i;
            }
        } else if (obj instanceof WikiPage) {
            WikiPage page = (WikiPage)obj;
            DocumentImpl document = new DocumentImpl();
            document.addUID(PORTLET_ID, page.getNodeId(), page.getTitle());
            SearchEngineUtil.deleteDocument((long)page.getCompanyId(), (String)document.get("uid"));
        }
    }

    protected void doReindex(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            return;
        }
        Document document = this.getDocument(page);
        SearchEngineUtil.updateDocument((long)page.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)classPK);
        this.doReindex(page);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexNodes(companyId);
    }

    protected Document doGetDocument(Object obj) throws Exception {
        WikiPage page = (WikiPage)obj;
        long companyId = page.getCompanyId();
        long groupId = this.getParentGroupId(page.getGroupId());
        long scopeGroupId = page.getGroupId();
        long userId = page.getUserId();
        long resourcePrimKey = page.getResourcePrimKey();
        long nodeId = page.getNodeId();
        String title = page.getTitle();
        String content = HtmlUtil.extractText((String)page.getContent());
        Date modifiedDate = page.getModifiedDate();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)WikiPage.class.getName(), (long)resourcePrimKey);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)WikiPage.class.getName(), (long)resourcePrimKey);
        ExpandoBridge expandoBridge = page.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, nodeId, title);
        document.addModifiedDate(modifiedDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        document.addText("title", title);
        document.addText("content", content);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("nodeId", nodeId);
        document.addKeyword("entryClassName", WikiPage.class.getName());
        document.addKeyword("entryClassPK", resourcePrimKey);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void checkSearchNodeId(long nodeId, SearchContext searchContext) throws Exception {
        WikiNodeServiceUtil.getNode((long)nodeId);
    }

    protected void reindexNodes(long companyId) throws Exception {
        int nodeCount = WikiNodeLocalServiceUtil.getCompanyNodesCount((long)companyId);
        int nodePages = nodeCount / 1000;
        int i = 0;
        while (i <= nodePages) {
            int nodeStart = i * 1000;
            int nodeEnd = nodeStart + 1000;
            this.reindexNodes(companyId, nodeStart, nodeEnd);
            ++i;
        }
    }

    protected void reindexNodes(long companyId, int nodeStart, int nodeEnd) throws Exception {
        List nodes = WikiNodeLocalServiceUtil.getCompanyNodes((long)companyId, (int)nodeStart, (int)nodeEnd);
        for (WikiNode node : nodes) {
            long nodeId = node.getNodeId();
            int pageCount = WikiPageLocalServiceUtil.getPagesCount((long)nodeId, (boolean)true);
            int pagePages = pageCount / 1000;
            int i = 0;
            while (i <= pagePages) {
                int pageStart = i * 1000;
                int pageEnd = pageStart + 1000;
                this.reindexPages(companyId, nodeId, pageStart, pageEnd);
                ++i;
            }
        }
    }

    protected void reindexPages(long companyId, long nodeId, int pageStart, int pageEnd) throws Exception {
        List pages = WikiPageLocalServiceUtil.getPages((long)nodeId, (boolean)true, (int)pageStart, (int)pageEnd);
        if (pages.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (WikiPage page : pages) {
            Document document = this.getDocument(page);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

