/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.model.impl;

import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.documentlibrary.service.DLServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageModelImpl;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageImpl
extends WikiPageModelImpl
implements WikiPage {
    private static Log _log = LogFactoryUtil.getLog(WikiPageImpl.class);
    private String _attachmentDirs;

    public String getAttachmentsDir() {
        if (this._attachmentDirs == null) {
            this._attachmentDirs = "wiki/" + this.getResourcePrimKey();
        }
        return this._attachmentDirs;
    }

    public String[] getAttachmentsFiles() throws PortalException, SystemException {
        String[] fileNames = new String[]{};
        try {
            fileNames = DLServiceUtil.getFileNames((long)this.getCompanyId(), (long)0L, (String)this.getAttachmentsDir());
        }
        catch (NoSuchDirectoryException noSuchDirectoryException) {}
        return fileNames;
    }

    public List<WikiPage> getChildPages() {
        ArrayList<WikiPage> pages = null;
        try {
            pages = WikiPageLocalServiceUtil.getChildren((long)this.getNodeId(), (boolean)true, (String)this.getTitle());
        }
        catch (Exception e) {
            pages = new ArrayList();
            _log.error((Throwable)e);
        }
        return pages;
    }

    public WikiNode getNode() {
        WikiNode node = null;
        try {
            node = WikiNodeLocalServiceUtil.getNode((long)this.getNodeId());
        }
        catch (Exception e) {
            node = new WikiNodeImpl();
            _log.error((Throwable)e);
        }
        return node;
    }

    public WikiPage getParentPage() {
        if (Validator.isNull((String)this.getParentTitle())) {
            return null;
        }
        WikiPage page = null;
        try {
            page = WikiPageLocalServiceUtil.getPage((long)this.getNodeId(), (String)this.getParentTitle());
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        return page;
    }

    public List<WikiPage> getParentPages() {
        ArrayList<WikiPage> parentPages = new ArrayList<WikiPage>();
        WikiPage parentPage = this.getParentPage();
        if (parentPage != null) {
            parentPages.addAll(parentPage.getParentPages());
            parentPages.add(parentPage);
        }
        return parentPages;
    }

    public WikiPage getRedirectPage() {
        if (Validator.isNull((String)this.getRedirectTitle())) {
            return null;
        }
        WikiPage page = null;
        try {
            page = WikiPageLocalServiceUtil.getPage((long)this.getNodeId(), (String)this.getRedirectTitle());
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        return page;
    }

    public void setAttachmentsDir(String attachmentsDir) {
        this._attachmentDirs = attachmentsDir;
    }
}

