/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.shopping.model.ShoppingCategory;
import com.liferay.portlet.shopping.service.base.ShoppingCategoryServiceBaseImpl;
import com.liferay.portlet.shopping.service.permission.ShoppingCategoryPermission;

public class ShoppingCategoryServiceImpl
extends ShoppingCategoryServiceBaseImpl {
    public ShoppingCategory addCategory(long parentCategoryId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingCategoryPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), parentCategoryId, "ADD_CATEGORY");
        return this.shoppingCategoryLocalService.addCategory(this.getUserId(), parentCategoryId, name, description, serviceContext);
    }

    public void deleteCategory(long categoryId) throws PortalException, SystemException {
        ShoppingCategory category = this.shoppingCategoryLocalService.getCategory(categoryId);
        ShoppingCategoryPermission.check(this.getPermissionChecker(), category, "DELETE");
        this.shoppingCategoryLocalService.deleteCategory(categoryId);
    }

    public ShoppingCategory getCategory(long categoryId) throws PortalException, SystemException {
        ShoppingCategory category = this.shoppingCategoryLocalService.getCategory(categoryId);
        ShoppingCategoryPermission.check(this.getPermissionChecker(), category, "VIEW");
        return category;
    }

    public ShoppingCategory updateCategory(long categoryId, long parentCategoryId, String name, String description, boolean mergeWithParentCategory, ServiceContext serviceContext) throws PortalException, SystemException {
        ShoppingCategory category = this.shoppingCategoryLocalService.getCategory(categoryId);
        ShoppingCategoryPermission.check(this.getPermissionChecker(), category, "UPDATE");
        return this.shoppingCategoryLocalService.updateCategory(categoryId, parentCategoryId, name, description, mergeWithParentCategory, serviceContext);
    }
}

