/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.portletconfiguration.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.portletconfiguration.action.EditConfigurationAction;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditSupportedClientsAction
extends EditConfigurationAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)actionRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.class.getName());
            this.setForward((PortletRequest)actionRequest, "portlet.portlet_configuration.error");
        }
        this.updateSupportedClients(portlet, actionRequest);
        this.sendRedirect(actionRequest, actionResponse);
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        Portlet portlet = null;
        try {
            portlet = this.getPortlet((PortletRequest)renderRequest);
        }
        catch (PrincipalException principalException) {
            SessionErrors.add((PortletRequest)renderRequest, (String)PrincipalException.class.getName());
            return mapping.findForward("portlet.portlet_configuration.error");
        }
        renderResponse.setTitle(this.getTitle(portlet, renderRequest));
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.portlet_configuration.edit_supported_clients"));
    }

    protected void updateSupportedClients(Portlet portlet, ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        PortletPreferences portletSetup = PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portlet.getPortletId());
        Set allPortletModes = portlet.getAllPortletModes();
        for (String portletMode : allPortletModes) {
            String mobileDevicesParam = "portlet-setup-supported-clients-mobile-devices-" + portletMode;
            boolean mobileDevices = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)mobileDevicesParam);
            portletSetup.setValue(mobileDevicesParam, String.valueOf(mobileDevices));
        }
        portletSetup.store();
    }
}

