/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.network.util;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portlet.network.model.DNSLookup;
import java.net.InetAddress;

public class DNSLookupWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 86400000L;
    private String _domain;

    public DNSLookupWebCacheItem(String domain) {
        this._domain = domain;
    }

    public Object convert(String key) throws WebCacheException {
        DNSLookup dnsLookup = null;
        try {
            String results = null;
            char[] array = this._domain.trim().toCharArray();
            int i = 0;
            while (i < array.length) {
                if (array[i] != '.' && !Character.isDigit(array[i])) {
                    InetAddress ia = InetAddress.getByName(this._domain);
                    results = ia.getHostAddress();
                    break;
                }
                ++i;
            }
            if (results == null) {
                InetAddress[] ia = InetAddress.getAllByName(this._domain);
                if (ia.length == 0) {
                    results = "";
                } else {
                    StringBundler sb = new StringBundler(ia.length * 2 - 1);
                    int i2 = 0;
                    while (i2 < ia.length) {
                        sb.append(ia[i2].getHostName());
                        if (i2 + 1 <= ia.length) {
                            sb.append(",");
                        }
                        ++i2;
                    }
                    results = sb.toString();
                }
            }
            dnsLookup = new DNSLookup(this._domain, results);
        }
        catch (Exception e) {
            throw new WebCacheException(String.valueOf(this._domain) + " " + e.toString());
        }
        return dnsLookup;
    }

    public long getRefreshTime() {
        return 86400000L;
    }
}

