/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.CompanyConstants;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.util.LinkbackProducerUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.messageboards.MessageBodyException;
import com.liferay.portlet.messageboards.MessageSubjectException;
import com.liferay.portlet.messageboards.NoSuchDiscussionException;
import com.liferay.portlet.messageboards.RequiredMessageException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBMessageDisplay;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.impl.MBCategoryImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageDisplayImpl;
import com.liferay.portlet.messageboards.service.base.MBMessageLocalServiceBaseImpl;
import com.liferay.portlet.messageboards.util.MBUtil;
import com.liferay.portlet.messageboards.util.MailingListThreadLocal;
import com.liferay.portlet.messageboards.util.comparator.MessageThreadComparator;
import com.liferay.portlet.messageboards.util.comparator.ThreadLastPostDateComparator;
import com.liferay.portlet.social.model.SocialActivity;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBMessageLocalServiceImpl
extends MBMessageLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(MBMessageLocalServiceImpl.class);

    public MBMessage addDiscussionMessage(long userId, String userName, long groupId, String className, long classPK, int workflowAction) throws PortalException, SystemException {
        String subject;
        long threadId = 0L;
        long parentMessageId = 0L;
        String body = subject = String.valueOf(classPK);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setWorkflowAction(workflowAction);
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            MBMessage mBMessage = this.addDiscussionMessage(userId, userName, groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
            return mBMessage;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public MBMessage addDiscussionMessage(long userId, String userName, long groupId, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        long classNameId;
        MBDiscussion discussion;
        long categoryId = MBCategoryConstants.DISCUSSION_CATEGORY_ID;
        if (Validator.isNull((String)subject)) {
            subject = String.valueOf(body.substring(0, Math.min(body.length(), 50))) + "...";
        }
        ArrayList<ObjectValuePair<String, byte[]>> files = new ArrayList<ObjectValuePair<String, byte[]>>();
        boolean anonymous = false;
        double priority = 0.0;
        boolean allowPingbacks = false;
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        MBMessage message = this.addMessage(userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, files, anonymous, priority, allowPingbacks, serviceContext);
        if (parentMessageId == MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID && (discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId = PortalUtil.getClassNameId((String)className), classPK)) == null) {
            discussion = this.mbDiscussionLocalService.addDiscussion(classNameId, classPK, message.getThreadId());
        }
        return message;
    }

    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, long threadId, long parentMessageId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage parentMessage;
        User user = this.userPersistence.findByPrimaryKey(userId);
        userName = user.isDefaultUser() ? userName : user.getFullName();
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences != null && !MBUtil.isAllowAnonymousPosting(preferences) && (anonymous || user.isDefaultUser())) {
            throw new PrincipalException();
        }
        if (user.isDefaultUser()) {
            anonymous = true;
        }
        Date now = new Date();
        this.validate(subject, body);
        long messageId = this.counterLocalService.increment();
        MBMessage message = this.mbMessagePersistence.create(messageId);
        message.setUuid(serviceContext.getUuid());
        message.setGroupId(groupId);
        message.setCompanyId(user.getCompanyId());
        message.setUserId(user.getUserId());
        message.setUserName(userName);
        message.setCreateDate(serviceContext.getCreateDate(now));
        message.setModifiedDate(serviceContext.getModifiedDate(now));
        message.setAllowPingbacks(allowPingbacks);
        message.setStatus(2);
        message.setStatusByUserId(user.getUserId());
        message.setStatusByUserName(userName);
        message.setStatusDate(serviceContext.getModifiedDate(now));
        if (parentMessageId != MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID && (parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(parentMessageId)) == null) {
            parentMessageId = MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID;
        }
        MBThread thread = null;
        if (threadId > 0L) {
            thread = this.mbThreadPersistence.fetchByPrimaryKey(threadId);
        }
        if (thread == null || parentMessageId == MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID) {
            threadId = this.counterLocalService.increment();
            thread = this.mbThreadPersistence.create(threadId);
            thread.setGroupId(groupId);
            thread.setCategoryId(categoryId);
            thread.setRootMessageId(messageId);
            thread.setStatus(2);
            thread.setStatusByUserId(user.getUserId());
            thread.setStatusByUserName(userName);
            thread.setStatusDate(serviceContext.getModifiedDate(now));
        }
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        message.setCategoryId(categoryId);
        message.setThreadId(threadId);
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(parentMessageId);
        message.setSubject(subject);
        message.setBody(body);
        message.setAttachments(!files.isEmpty());
        message.setAnonymous(anonymous);
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        if (message.isDiscussion()) {
            long classNameId = PortalUtil.getClassNameId((String)((String)((Object)serviceContext.getAttribute("className"))));
            long classPK = GetterUtil.getLong((String)((String)((Object)serviceContext.getAttribute("classPK"))));
            message.setClassNameId(classNameId);
            message.setClassPK(classPK);
        }
        if (files.size() > 0) {
            String dirName;
            long repositoryId;
            long dlGroupId;
            String portletId;
            long companyId;
            block18: {
                companyId = message.getCompanyId();
                portletId = CompanyConstants.SYSTEM_STRING;
                dlGroupId = 0L;
                repositoryId = 0L;
                dirName = message.getAttachmentsDir();
                try {
                    this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
                }
                catch (NoSuchDirectoryException nsde) {
                    if (!_log.isDebugEnabled()) break block18;
                    _log.debug((Object)nsde.getMessage());
                }
            }
            this.dlService.addDirectory(companyId, repositoryId, dirName);
            int i = 0;
            while (i < files.size()) {
                block19: {
                    ObjectValuePair<String, byte[]> ovp = files.get(i);
                    String fileName = (String)ovp.getKey();
                    byte[] bytes = (byte[])ovp.getValue();
                    try {
                        this.dlService.addFile(companyId, portletId, dlGroupId, repositoryId, String.valueOf(dirName) + "/" + fileName, 0L, "", message.getModifiedDate(), new ServiceContext(), bytes);
                    }
                    catch (DuplicateFileException dfe) {
                        if (!_log.isDebugEnabled()) break block19;
                        _log.debug((Object)dfe.getMessage());
                    }
                }
                ++i;
            }
        }
        this.mbThreadPersistence.update((BaseModel)thread, false);
        this.mbMessagePersistence.update((BaseModel)message, false);
        if (!message.isDiscussion()) {
            if (user.isDefaultUser()) {
                this.addMessageResources(message, true, true);
            }
            if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
                this.addMessageResources(message, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
            } else {
                this.addMessageResources(message, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
            }
        }
        this.updateAsset(userId, message, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        ExpandoBridge expandoBridge = message.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)user.getCompanyId(), (long)groupId, (long)userId, (String)message.getWorkflowClassName(), (long)message.getMessageId(), (Object)message, (ServiceContext)serviceContext);
        return message;
    }

    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        long threadId = 0L;
        long parentMessageId = 0L;
        return this.addMessage(userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, files, anonymous, priority, allowPingbacks, serviceContext);
    }

    public void addMessageResources(long messageId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, addCommunityPermissions, addGuestPermissions);
    }

    public void addMessageResources(long messageId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, communityPermissions, guestPermissions);
    }

    public void addMessageResources(MBMessage message, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addMessageResources(MBMessage message, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), communityPermissions, guestPermissions);
    }

    public void deleteDiscussionMessage(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        messages.add(message);
        this.deleteDiscussionSocialActivities(BlogsEntry.class.getName(), messages);
        this.deleteMessage(message);
    }

    public void deleteDiscussionMessages(String className, long classPK) throws PortalException, SystemException {
        block3: {
            try {
                long classNameId = PortalUtil.getClassNameId((String)className);
                MBDiscussion discussion = this.mbDiscussionPersistence.findByC_C(classNameId, classPK);
                List messages = this.mbMessagePersistence.findByT_P(discussion.getThreadId(), MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID, 0, 1);
                this.deleteDiscussionSocialActivities(BlogsEntry.class.getName(), messages);
                if (messages.size() > 0) {
                    MBMessage message = (MBMessage)messages.get(0);
                    this.mbThreadLocalService.deleteThread(message.getThreadId());
                }
                this.mbDiscussionPersistence.remove((BaseModel)discussion);
            }
            catch (NoSuchDiscussionException nsde) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsde.getMessage());
            }
        }
    }

    public void deleteMessage(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.deleteMessage(message);
    }

    public void deleteMessage(MBMessage message) throws PortalException, SystemException {
        block21: {
            Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
            indexer.delete((Object)message);
            if (message.isAttachments()) {
                long companyId = message.getCompanyId();
                String portletId = CompanyConstants.SYSTEM_STRING;
                long repositoryId = 0L;
                String dirName = message.getAttachmentsDir();
                try {
                    this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
                }
                catch (NoSuchDirectoryException nsde) {
                    if (!_log.isDebugEnabled()) break block21;
                    _log.debug((Object)nsde.getMessage());
                }
            }
        }
        int count = this.mbMessagePersistence.countByThreadId(message.getThreadId());
        if (message.isRoot()) {
            this.mbMessageFlagLocalService.deleteQuestionAndAnswerFlags(message.getThreadId());
        } else if (this.mbMessageFlagLocalService.hasAnswerFlag(message.getMessageId())) {
            this.mbMessageFlagService.deleteAnswerFlag(message.getMessageId());
        }
        if (count == 1) {
            block22: {
                long companyId = message.getCompanyId();
                String portletId = CompanyConstants.SYSTEM_STRING;
                long repositoryId = 0L;
                String dirName = message.getThreadAttachmentsDir();
                try {
                    this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
                }
                catch (NoSuchDirectoryException nsde) {
                    if (!_log.isDebugEnabled()) break block22;
                    _log.debug((Object)nsde.getMessage());
                }
            }
            this.subscriptionLocalService.deleteSubscriptions(message.getCompanyId(), MBThread.class.getName(), message.getThreadId());
            this.mbThreadPersistence.remove(message.getThreadId());
            if (message.getCategoryId() != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && message.getCategoryId() != MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
                MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
                category.setThreadCount(category.getThreadCount() - 1);
                category.setMessageCount(category.getMessageCount() - 1);
                this.mbCategoryPersistence.update((BaseModel)category, false);
            }
        } else if (count > 1) {
            List childrenMessages;
            MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
            if (thread.getRootMessageId() == message.getMessageId()) {
                childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (childrenMessages.size() > 1) {
                    throw new RequiredMessageException(String.valueOf(message.getMessageId()));
                }
                if (childrenMessages.size() == 1) {
                    MBMessage childMessage = (MBMessage)childrenMessages.get(0);
                    childMessage.setRootMessageId(childMessage.getMessageId());
                    childMessage.setParentMessageId(MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID);
                    this.mbMessagePersistence.update((BaseModel)childMessage, false);
                    thread.setRootMessageId(childMessage.getMessageId());
                    this.mbThreadPersistence.update((BaseModel)thread, false);
                }
            } else {
                childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (childrenMessages.size() > 0) {
                    for (MBMessage childMessage : childrenMessages) {
                        childMessage.setParentMessageId(message.getParentMessageId());
                        this.mbMessagePersistence.update((BaseModel)childMessage, false);
                    }
                }
            }
            thread.setMessageCount(count - 1);
            this.mbThreadPersistence.update((BaseModel)thread, false);
            if (message.getCategoryId() != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && message.getCategoryId() != MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
                MBCategory category = this.mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
                category.setMessageCount(category.getMessageCount() - 1);
                this.mbCategoryPersistence.update((BaseModel)category, false);
            }
        }
        this.assetEntryLocalService.deleteEntry(MBMessage.class.getName(), message.getMessageId());
        this.expandoValueLocalService.deleteValues(MBMessage.class.getName(), message.getMessageId());
        this.socialActivityLocalService.deleteActivities(MBMessage.class.getName(), message.getMessageId());
        this.ratingsStatsLocalService.deleteStats(MBMessage.class.getName(), message.getMessageId());
        if (!message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
        }
        this.mbMessageFlagPersistence.removeByMessageId(message.getMessageId());
        if (!message.isDiscussion()) {
            this.resourceLocalService.deleteResource(message.getCompanyId(), MBMessage.class.getName(), 4, message.getMessageId());
        }
        this.mbMessagePersistence.remove((BaseModel)message);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbMessagePersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_C(groupId, categoryId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_C_S(groupId, categoryId, status, start, end, obc);
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByG_C(groupId, categoryId);
        }
        return this.mbMessagePersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByCompanyId(companyId, start, end);
        }
        return this.mbMessagePersistence.findByC_S(companyId, status, start, end);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByCompanyId(companyId, start, end, obc);
        }
        return this.mbMessagePersistence.findByC_S(companyId, status, start, end, obc);
    }

    public int getCompanyMessagesCount(long companyId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByCompanyId(companyId);
        }
        return this.mbMessagePersistence.countByC_S(companyId, status);
    }

    public MBMessageDisplay getDiscussionMessageDisplay(long userId, long groupId, String className, long classPK, int status) throws PortalException, SystemException {
        return this.getDiscussionMessageDisplay(userId, groupId, className, classPK, status, "combination");
    }

    public MBMessageDisplay getDiscussionMessageDisplay(long userId, long groupId, String className, long classPK, int status, String threadView) throws PortalException, SystemException {
        MBMessage message;
        block9: {
            long classNameId = PortalUtil.getClassNameId((String)className);
            message = null;
            MBDiscussion discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
            if (discussion != null) {
                List messages = this.mbMessagePersistence.findByT_P(discussion.getThreadId(), MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID);
                message = (MBMessage)messages.get(0);
            } else {
                boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
                WorkflowThreadLocal.setEnabled((boolean)false);
                try {
                    try {
                        String subject = String.valueOf(classPK);
                        message = this.addDiscussionMessage(userId, null, groupId, className, classPK, 0L, MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID, subject, subject, new ServiceContext());
                    }
                    catch (SystemException se) {
                        List messages;
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("Add failed, fetch {threadId=0, parentMessageId=" + MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID + "}"));
                        }
                        if ((messages = this.mbMessagePersistence.findByT_P(0L, MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID)).isEmpty()) {
                            throw se;
                        }
                        message = (MBMessage)messages.get(0);
                        WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
                    throw throwable;
                }
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        }
        return this.getMessageDisplay(message, status, threadView, false);
    }

    public int getDiscussionMessagesCount(long classNameId, long classPK, int status) throws SystemException {
        MBDiscussion discussion = this.mbDiscussionPersistence.fetchByC_C(classNameId, classPK);
        if (discussion == null) {
            return 0;
        }
        int count = 0;
        count = status == -1 ? this.mbMessagePersistence.countByThreadId(discussion.getThreadId()) : this.mbMessagePersistence.countByT_S(discussion.getThreadId(), status);
        if (count >= 1) {
            return count - 1;
        }
        return 0;
    }

    public int getDiscussionMessagesCount(String className, long classPK, int status) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getDiscussionMessagesCount(classNameId, classPK, status);
    }

    public List<MBDiscussion> getDiscussions(String className) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mbDiscussionPersistence.findByClassNameId(classNameId);
    }

    public List<MBMessage> getGroupMessages(long groupId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByGroupId(groupId, start, end);
        }
        return this.mbMessagePersistence.findByG_S(groupId, status, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByGroupId(groupId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_S(groupId, status, start, end, obc);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_U(groupId, userId, start, end);
        }
        return this.mbMessagePersistence.findByG_U_S(groupId, userId, status, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int status, int start, int end, OrderByComparator obc) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_U(groupId, userId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_U_S(groupId, userId, status, start, end, obc);
    }

    public int getGroupMessagesCount(long groupId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByGroupId(groupId);
        }
        return this.mbMessagePersistence.countByG_S(groupId, status);
    }

    public int getGroupMessagesCount(long groupId, long userId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByG_U(groupId, userId);
        }
        return this.mbMessagePersistence.countByG_U_S(groupId, userId, status);
    }

    public MBMessage getMessage(long messageId) throws PortalException, SystemException {
        return this.mbMessagePersistence.findByPrimaryKey(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long messageId, int status, String threadView, boolean includePrevAndNext) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        return this.getMessageDisplay(message, status, threadView, includePrevAndNext);
    }

    public MBMessageDisplay getMessageDisplay(MBMessage message, int status, String threadView, boolean includePrevAndNext) throws PortalException, SystemException {
        MBCategoryImpl category = null;
        if (message.getCategoryId() != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && message.getCategoryId() != MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            category = this.mbCategoryPersistence.findByPrimaryKey(message.getCategoryId());
        } else {
            category = new MBCategoryImpl();
            category.setCategoryId(message.getCategoryId());
        }
        MBMessage parentMessage = null;
        if (message.isReply()) {
            parentMessage = this.mbMessagePersistence.findByPrimaryKey(message.getParentMessageId());
        }
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (!message.isDiscussion() && message.getStatus() == 0) {
            this.mbThreadLocalService.updateThread(thread.getThreadId(), thread.getViewCount() + 1);
        }
        MBThread previousThread = null;
        MBThread nextThread = null;
        if (message.getStatus() == 0 && includePrevAndNext) {
            ThreadLastPostDateComparator comparator = new ThreadLastPostDateComparator(false);
            MBThread[] prevAndNextThreads = this.mbThreadPersistence.findByG_C_PrevAndNext(message.getThreadId(), message.getGroupId(), message.getCategoryId(), (OrderByComparator)comparator);
            previousThread = prevAndNextThreads[0];
            nextThread = prevAndNextThreads[2];
        }
        return new MBMessageDisplayImpl(message, parentMessage, category, thread, previousThread, nextThread, status, threadView);
    }

    public List<MBMessage> getMessages(String className, long classPK, int status) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        if (status == -1) {
            return this.mbMessagePersistence.findByC_C(classNameId, classPK);
        }
        return this.mbMessagePersistence.findByC_C_S(classNameId, classPK, status);
    }

    public List<MBMessage> getNoAssetMessages() throws SystemException {
        return this.mbMessageFinder.findByNoAssets();
    }

    public int getPositionInThread(long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageFinder.countByC_T(message.getCreateDate(), message.getThreadId());
    }

    public List<MBMessage> getThreadMessages(long threadId, int status) throws SystemException {
        return this.getThreadMessages(threadId, status, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    public List<MBMessage> getThreadMessages(long threadId, int status, Comparator<MBMessage> comparator) throws SystemException {
        List messages = null;
        messages = status == -1 ? this.mbMessagePersistence.findByThreadId(threadId) : this.mbMessagePersistence.findByT_S(threadId, status);
        return ListUtil.sort((List)messages, comparator);
    }

    public List<MBMessage> getThreadMessages(long threadId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByThreadId(threadId, start, end);
        }
        return this.mbMessagePersistence.findByT_S(threadId, status, start, end);
    }

    public int getThreadMessagesCount(long threadId, int status) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.countByThreadId(threadId);
        }
        return this.mbMessagePersistence.countByT_S(threadId, status);
    }

    public List<MBMessage> getThreadRepliesMessages(long threadId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.mbMessagePersistence.findByThreadReplies(threadId, start, end);
        }
        return this.mbMessagePersistence.findByTR_S(threadId, status, start, end);
    }

    public void subscribeMessage(long userId, long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.subscriptionLocalService.addSubscription(userId, MBThread.class.getName(), message.getThreadId());
    }

    public void unsubscribeMessage(long userId, long messageId) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.subscriptionLocalService.deleteSubscription(userId, MBThread.class.getName(), message.getThreadId());
    }

    public void updateAsset(long userId, MBMessage message, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        boolean visible = false;
        if (message.getStatus() == 0) {
            visible = true;
        }
        this.assetEntryLocalService.updateEntry(userId, message.getGroupId(), message.getWorkflowClassName(), message.getMessageId(), message.getUuid(), assetCategoryIds, assetTagNames, visible, null, null, null, null, "text/html", message.getSubject(), null, null, null, 0, 0, null, false);
    }

    public MBMessage updateDiscussionMessage(long userId, long messageId, String subject, String body, int workflowAction) throws PortalException, SystemException {
        if (Validator.isNull((String)subject)) {
            subject = String.valueOf(body.substring(0, Math.min(body.length(), 50))) + "...";
        }
        ArrayList<ObjectValuePair<String, byte[]>> files = new ArrayList<ObjectValuePair<String, byte[]>>();
        ArrayList<String> existingFiles = new ArrayList<String>();
        double priority = 0.0;
        boolean allowPingbacks = false;
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setWorkflowAction(workflowAction);
        return this.updateMessage(userId, messageId, subject, body, files, existingFiles, priority, allowPingbacks, serviceContext);
    }

    public MBMessage updateMessage(long userId, long messageId, String subject, String body, List<ObjectValuePair<String, byte[]>> files, List<String> existingFiles, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        Date now = new Date();
        this.validate(subject, body);
        message.setModifiedDate(serviceContext.getModifiedDate(now));
        message.setSubject(subject);
        message.setBody(body);
        message.setAttachments(!files.isEmpty() || !existingFiles.isEmpty());
        message.setAllowPingbacks(allowPingbacks);
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        long companyId = message.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long groupId = 0L;
        long repositoryId = 0L;
        String dirName = message.getAttachmentsDir();
        if (!files.isEmpty() || !existingFiles.isEmpty()) {
            String[] fileNames;
            try {
                this.dlService.addDirectory(companyId, repositoryId, dirName);
            }
            catch (DuplicateDirectoryException duplicateDirectoryException) {}
            String[] stringArray = fileNames = this.dlService.getFileNames(companyId, repositoryId, dirName);
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                if (!existingFiles.contains(fileName)) {
                    this.dlService.deleteFile(companyId, portletId, repositoryId, fileName);
                }
                ++n2;
            }
            int i = 0;
            while (i < files.size()) {
                ObjectValuePair<String, byte[]> ovp = files.get(i);
                String fileName = (String)ovp.getKey();
                byte[] bytes = (byte[])ovp.getValue();
                try {
                    this.dlService.addFile(companyId, portletId, groupId, repositoryId, String.valueOf(dirName) + "/" + fileName, 0L, "", message.getModifiedDate(), new ServiceContext(), bytes);
                }
                catch (DuplicateFileException duplicateFileException) {}
                ++i;
            }
        } else {
            try {
                this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
            }
            catch (NoSuchDirectoryException noSuchDirectoryException) {}
        }
        this.mbMessagePersistence.update((BaseModel)message, false);
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this.mbThreadPersistence.update((BaseModel)thread, false);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        this.updateAsset(userId, message, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        ExpandoBridge expandoBridge = message.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
        serviceContext.setAttribute("update", (Serializable)((Object)Boolean.TRUE.toString()));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)companyId, (long)message.getGroupId(), (long)userId, (String)message.getWorkflowClassName(), (long)message.getMessageId(), (Object)message, (ServiceContext)serviceContext);
        return message;
    }

    public MBMessage updateMessage(long messageId, String body) throws PortalException, SystemException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        message.setBody(body);
        this.mbMessagePersistence.update((BaseModel)message, false);
        return message;
    }

    public MBMessage updateStatus(long userId, long messageId, int status, ServiceContext serviceContext) throws PortalException, SystemException {
        MBMessage message = this.getMessage(messageId);
        int oldStatus = message.getStatus();
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        message.setStatus(status);
        message.setStatusByUserId(userId);
        message.setStatusByUserName(user.getFullName());
        message.setStatusDate(serviceContext.getModifiedDate(now));
        this.mbMessagePersistence.update((BaseModel)message, false);
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(message.getThreadId());
        MBCategory category = null;
        if (thread.getCategoryId() != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && thread.getCategoryId() != MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            category = this.mbCategoryPersistence.findByPrimaryKey(thread.getCategoryId());
        }
        if (thread.getRootMessageId() == message.getMessageId() && oldStatus != status) {
            thread.setStatus(status);
            thread.setStatusByUserId(userId);
            thread.setStatusByUserName(user.getFullName());
            thread.setStatusDate(serviceContext.getModifiedDate(now));
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
        if (status == 0) {
            if (oldStatus != 0) {
                if (category != null && thread.getRootMessageId() == message.getMessageId()) {
                    category.setThreadCount(category.getThreadCount() + 1);
                    this.mbCategoryPersistence.update((BaseModel)category, false);
                }
                thread.setMessageCount(thread.getMessageCount() + 1);
                if (message.isAnonymous()) {
                    thread.setLastPostByUserId(0L);
                } else {
                    thread.setLastPostByUserId(message.getUserId());
                }
                thread.setLastPostDate(serviceContext.getModifiedDate(now));
                if (category != null) {
                    category.setMessageCount(category.getMessageCount() + 1);
                    category.setLastPostDate(serviceContext.getModifiedDate(now));
                    this.mbCategoryPersistence.update((BaseModel)category, false);
                }
                if (!message.isDiscussion()) {
                    this.assetEntryLocalService.updateVisible(MBMessage.class.getName(), message.getMessageId(), true);
                    if (!message.isAnonymous() && !user.isDefaultUser()) {
                        int activityType = 1;
                        long receiverUserId = 0L;
                        String actionId = "ADD_MESSAGE";
                        MBMessage parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(message.getParentMessageId());
                        if (parentMessage != null) {
                            activityType = 2;
                            receiverUserId = parentMessage.getUserId();
                            if (receiverUserId != userId) {
                                actionId = "REPLY_TO_MESSAGE";
                            }
                        }
                        this.socialActivityLocalService.addActivity(userId, message.getGroupId(), MBMessage.class.getName(), message.getMessageId(), activityType, "", receiverUserId);
                        this.socialEquityLogLocalService.addEquityLogs(userId, MBMessage.class.getName(), messageId, actionId);
                    }
                }
                this.notifySubscribers(message, serviceContext);
            }
            if (!message.isDiscussion()) {
                indexer.reindex((Object)message);
            }
            this.pingPingback(message, serviceContext);
            if (message.isDiscussion()) {
                this.updateDiscussionMessageStatus(userId, messageId, status, oldStatus, serviceContext);
            }
        } else if (oldStatus == 0 && status != 0) {
            if (category != null && thread.getRootMessageId() == message.getMessageId()) {
                category.setThreadCount(category.getThreadCount() - 1);
                this.mbCategoryPersistence.update((BaseModel)category, false);
            }
            thread.setMessageCount(thread.getMessageCount() - 1);
            if (category != null) {
                category.setMessageCount(category.getMessageCount() - 1);
                this.mbCategoryPersistence.update((BaseModel)category, false);
            }
            if (!message.isDiscussion()) {
                this.assetEntryLocalService.updateVisible(MBMessage.class.getName(), message.getMessageId(), false);
                indexer.delete((Object)message);
            }
        }
        if (status != oldStatus) {
            this.mbThreadPersistence.update((BaseModel)thread, false);
        }
        if (!message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), userId, serviceContext.getModifiedDate(now));
        }
        return message;
    }

    public void updateUserName(long userId, String userName) throws SystemException {
        List messages = this.mbMessagePersistence.findByUserId(userId);
        for (MBMessage message : messages) {
            message.setUserName(userName);
            this.mbMessagePersistence.update((BaseModel)message, false);
        }
    }

    protected void deleteDiscussionSocialActivities(String className, List<MBMessage> messages) throws PortalException, SystemException {
        if (messages.size() == 0) {
            return;
        }
        MBMessage message = messages.get(0);
        MBDiscussion discussion = this.mbDiscussionPersistence.findByThreadId(message.getThreadId());
        long classNameId = PortalUtil.getClassNameId((String)className);
        long classPK = discussion.getClassPK();
        if (discussion.getClassNameId() != classNameId) {
            return;
        }
        HashSet<Long> messageIds = new HashSet<Long>();
        for (MBMessage curMessage : messages) {
            messageIds.add(curMessage.getMessageId());
        }
        List socialActivities = this.socialActivityLocalService.getActivities(0L, className, classPK, -1, -1);
        for (SocialActivity socialActivity : socialActivities) {
            JSONObject extraData;
            long extraDataMessageId;
            if (Validator.isNull((String)socialActivity.getExtraData()) || !messageIds.contains(extraDataMessageId = (extraData = JSONFactoryUtil.createJSONObject((String)socialActivity.getExtraData())).getLong("messageId"))) continue;
            this.socialActivityLocalService.deleteActivity(socialActivity.getActivityId());
        }
    }

    protected void notifySubscribers(MBMessage message, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean update;
        if (message.getStatus() != 0) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL) || message.isDiscussion()) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = message.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "19";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(message.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(!(update = GetterUtil.getBoolean((String)((String)((Object)serviceContext.getAttribute("update"))))) && MBUtil.getEmailMessageAddedEnabled(preferences) || update && MBUtil.getEmailMessageUpdatedEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(message.getCompanyId());
        Group group = this.groupPersistence.findByPrimaryKey(message.getGroupId());
        String emailAddress = "";
        String fullName = message.getUserName();
        try {
            User user = this.userPersistence.findByPrimaryKey(message.getUserId());
            emailAddress = user.getEmailAddress();
            fullName = user.getFullName();
        }
        catch (NoSuchUserException noSuchUserException) {}
        MBCategory category = message.getCategory();
        if (message.isAnonymous()) {
            emailAddress = "";
            fullName = LanguageUtil.get((Locale)ServiceContextUtil.getLocale((ServiceContext)serviceContext), (String)"anonymous");
        }
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(message.getCategoryId());
        if (message.getCategoryId() != MBCategoryConstants.DEFAULT_PARENT_CATEGORY_ID && message.getCategoryId() != MBCategoryConstants.DISCUSSION_CATEGORY_ID) {
            categoryIds.addAll(category.getAncestorCategoryIds());
        }
        String messageURL = String.valueOf(layoutFullURL) + "/-/" + "message_boards/view_message/" + message.getMessageId();
        String portletName = PortalUtil.getPortletTitle((String)"19", (Locale)LocaleUtil.getDefault());
        String fromName = MBUtil.getEmailFromName(preferences);
        String fromAddress = MBUtil.getEmailFromAddress(preferences);
        String mailingListAddress = "";
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            mailingListAddress = MBUtil.getMailingListAddress(message.getGroupId(), message.getCategoryId(), message.getMessageId(), company.getMx(), fromAddress);
        }
        String replyToAddress = mailingListAddress;
        String mailId = MBUtil.getMailId(company.getMx(), message.getCategoryId(), message.getMessageId());
        fromName = StringUtil.replace((String)fromName, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$MAILING_LIST_ADDRESS$]", "[$MESSAGE_USER_ADDRESS$]", "[$MESSAGE_USER_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), mailingListAddress, emailAddress, fullName, portletName});
        fromAddress = StringUtil.replace((String)fromAddress, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$MAILING_LIST_ADDRESS$]", "[$MESSAGE_USER_ADDRESS$]", "[$MESSAGE_USER_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), mailingListAddress, emailAddress, fullName, portletName});
        String subjectPrefix = null;
        String body = null;
        String signature = null;
        boolean htmlFormat = MBUtil.getEmailHtmlFormat(preferences);
        if (update) {
            subjectPrefix = MBUtil.getEmailMessageUpdatedSubjectPrefix(preferences);
            body = MBUtil.getEmailMessageUpdatedBody(preferences);
            signature = MBUtil.getEmailMessageUpdatedSignature(preferences);
        } else {
            subjectPrefix = MBUtil.getEmailMessageAddedSubjectPrefix(preferences);
            body = MBUtil.getEmailMessageAddedBody(preferences);
            signature = MBUtil.getEmailMessageAddedSignature(preferences);
        }
        if (Validator.isNotNull((String)signature)) {
            body = String.valueOf(body) + "\n--\n" + signature;
        }
        subjectPrefix = StringUtil.replace((String)subjectPrefix, (String[])new String[]{"[$CATEGORY_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$MAILING_LIST_ADDRESS$]", "[$MESSAGE_BODY$]", "[$MESSAGE_ID$]", "[$MESSAGE_SUBJECT$]", "[$MESSAGE_USER_ADDRESS$]", "[$MESSAGE_USER_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{category.getName(), String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, mailingListAddress, message.getBody(), String.valueOf(message.getMessageId()), message.getSubject(), emailAddress, fullName, company.getVirtualHost(), portletName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$CATEGORY_NAME$]", "[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$MAILING_LIST_ADDRESS$]", "[$MESSAGE_BODY$]", "[$MESSAGE_ID$]", "[$MESSAGE_SUBJECT$]", "[$MESSAGE_URL$]", "[$MESSAGE_USER_ADDRESS$]", "[$MESSAGE_USER_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{category.getName(), String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, mailingListAddress, message.getBody(), String.valueOf(message.getMessageId()), message.getSubject(), messageURL, emailAddress, fullName, company.getVirtualHost(), portletName});
        String subject = message.getSubject();
        if (subject.indexOf(subjectPrefix) == -1) {
            subject = String.valueOf(subjectPrefix.trim()) + " " + subject.trim();
        }
        String inReplyTo = null;
        if (message.getParentMessageId() != MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID) {
            inReplyTo = MBUtil.getMailId(company.getMx(), message.getCategoryId(), message.getParentMessageId());
        }
        Message messagingObj = new Message();
        messagingObj.put("companyId", (Object)message.getCompanyId());
        messagingObj.put("userId", (Object)message.getUserId());
        messagingObj.put("groupId", (Object)message.getGroupId());
        messagingObj.put("categoryIds", (Object)StringUtil.merge(categoryIds));
        messagingObj.put("threadId", (Object)message.getThreadId());
        messagingObj.put("fromName", (Object)fromName);
        messagingObj.put("fromAddress", (Object)fromAddress);
        messagingObj.put("subject", (Object)subject);
        messagingObj.put("body", (Object)body);
        messagingObj.put("replyToAddress", (Object)replyToAddress);
        messagingObj.put("mailId", (Object)mailId);
        messagingObj.put("inReplyTo", (Object)inReplyTo);
        messagingObj.put("htmlFormat", (Object)htmlFormat);
        messagingObj.put("sourceMailingList", (Object)MailingListThreadLocal.isSourceMailingList());
        MessageBusUtil.sendMessage((String)"liferay/message_boards", (Message)messagingObj);
    }

    protected void pingPingback(MBMessage message, ServiceContext serviceContext) {
        if (!PropsValues.BLOGS_PINGBACK_ENABLED || !message.isAllowPingbacks() || message.getStatus() != 0) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        String sourceUri = String.valueOf(layoutFullURL) + "/-/" + "message_boards/view_message/" + message.getMessageId();
        Source source = new Source((CharSequence)message.getBody(true));
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            String targetUri = startTag.getAttributeValue("href");
            if (!Validator.isNotNull((String)targetUri)) continue;
            try {
                LinkbackProducerUtil.sendPingback(sourceUri, targetUri);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending pingback " + targetUri), (Throwable)e);
            }
        }
    }

    protected void sendBlogsCommentsEmail(long userId, BlogsEntry entry, MBMessage message, ServiceContext serviceContext) throws IOException, PortalException, SystemException {
        long companyId = message.getCompanyId();
        if (!PrefsPropsUtil.getBoolean(companyId, "blogs.email.comments.added.enabled")) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        String blogsEntryURL = String.valueOf(layoutFullURL) + "/-/" + "blogs/" + entry.getUrlTitle();
        User user = this.userPersistence.findByPrimaryKey(userId);
        String fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        String subject = PrefsPropsUtil.getContent(companyId, "blogs.email.comments.added.subject");
        String body = PrefsPropsUtil.getContent(companyId, "blogs.email.comments.added.body");
        subject = StringUtil.replace((String)subject, (String[])new String[]{"[$BLOGS_COMMENTS_BODY$]", "[$BLOGS_COMMENTS_USER_ADDRESS$]", "[$BLOGS_COMMENTS_USER_NAME$]", "[$BLOGS_ENTRY_URL$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]"}, (String[])new String[]{message.getBody(), user.getEmailAddress(), user.getFullName(), blogsEntryURL, fromAddress, fromName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$BLOGS_COMMENTS_BODY$]", "[$BLOGS_COMMENTS_USER_ADDRESS$]", "[$BLOGS_COMMENTS_USER_NAME$]", "[$BLOGS_ENTRY_URL$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]"}, (String[])new String[]{message.getBody(), user.getEmailAddress(), user.getFullName(), blogsEntryURL, fromAddress, fromName});
        HashSet<Long> sent = new HashSet<Long>();
        List messages = this.mbMessagePersistence.findByThreadId(message.getThreadId());
        for (MBMessage curMessage : messages) {
            long curMessageUserId = curMessage.getUserId();
            if (curMessageUserId == userId) continue;
            if (sent.contains(curMessageUserId)) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not send a duplicate email to user " + curMessageUserId));
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add user " + curMessageUserId + " to the list of users who have received an email"));
            }
            sent.add(curMessageUserId);
            User curMessageUser = null;
            try {
                curMessageUser = this.userLocalService.getUserById(curMessageUserId);
            }
            catch (NoSuchUserException noSuchUserException) {
                continue;
            }
            if (!curMessageUser.isActive()) continue;
            InternetAddress from = new InternetAddress(fromAddress, fromName);
            InternetAddress to = new InternetAddress(curMessageUser.getEmailAddress(), curMessageUser.getFullName());
            String curSubject = StringUtil.replace((String)subject, (String[])new String[]{"[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{curMessageUser.getFullName(), curMessageUser.getEmailAddress()});
            String curBody = StringUtil.replace((String)body, (String[])new String[]{"[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{curMessageUser.getFullName(), curMessageUser.getEmailAddress()});
            MailMessage mailMessage = new MailMessage(from, to, curSubject, curBody, true);
            this.mailService.sendEmail(mailMessage);
        }
    }

    protected void updateDiscussionMessageStatus(long userId, long messageId, int status, int oldStatus, ServiceContext serviceContext) throws PortalException, SystemException {
        String className = (String)((Object)serviceContext.getAttribute("className"));
        long classPK = GetterUtil.getLong((String)((String)((Object)serviceContext.getAttribute("classPK"))));
        MBMessage message = this.getMessage(messageId);
        if (oldStatus != 0 && status == 0) {
            if (!message.isRoot()) {
                this.socialEquityLogLocalService.addEquityLogs(userId, className, classPK, "ADD_DISCUSSION");
            }
            long parentMessageId = message.getParentMessageId();
            if (className.equals(BlogsEntry.class.getName()) && parentMessageId != MBMessageConstants.DEFAULT_PARENT_MESSAGE_ID) {
                BlogsEntry entry = this.blogsEntryPersistence.findByPrimaryKey(classPK);
                JSONObject extraData = JSONFactoryUtil.createJSONObject();
                extraData.put("messageId", message.getMessageId());
                this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BlogsEntry.class.getName(), classPK, 1, extraData.toString(), entry.getUserId());
                try {
                    this.sendBlogsCommentsEmail(userId, entry, message, serviceContext);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected void updatePriorities(long threadId, double priority) throws SystemException {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            if (message.getPriority() == priority) continue;
            message.setPriority(priority);
            this.mbMessagePersistence.update((BaseModel)message, false);
        }
    }

    protected void validate(String subject, String body) throws PortalException {
        if (Validator.isNull((String)subject)) {
            throw new MessageSubjectException();
        }
        if (Validator.isNull((String)body)) {
            throw new MessageBodyException();
        }
    }
}

