/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.model.impl.JournalArticleModelImpl;
import com.liferay.portlet.journal.service.JournalArticleResourceLocalServiceUtil;
import com.liferay.portlet.journal.util.LocaleTransformerListener;
import java.util.Locale;

public class JournalArticleImpl
extends JournalArticleModelImpl
implements JournalArticle {
    private String _smallImageType;

    public static String getContentByLocale(String content, boolean templateDriven, String languageId) {
        LocaleTransformerListener listener = new LocaleTransformerListener();
        listener.setTemplateDriven(templateDriven);
        listener.setLanguageId(languageId);
        return listener.onXml(content);
    }

    public JournalArticleResource getArticleResource() throws PortalException, SystemException {
        return JournalArticleResourceLocalServiceUtil.getArticleResource((long)this.getResourcePrimKey());
    }

    public String getArticleResourceUuid() throws PortalException, SystemException {
        JournalArticleResource articleResource = this.getArticleResource();
        return articleResource.getUuid();
    }

    public String[] getAvailableLocales() {
        return LocalizationUtil.getAvailableLocales((String)this.getContent());
    }

    public String getContentByLocale(String languageId) {
        return JournalArticleImpl.getContentByLocale(this.getContent(), this.isTemplateDriven(), languageId);
    }

    public String getDefaultLocale() {
        String xml = this.getContent();
        if (xml == null) {
            return "";
        }
        String defaultLanguageId = LocalizationUtil.getDefaultLocale((String)xml);
        if (this.isTemplateDriven() && Validator.isNull((String)defaultLanguageId)) {
            defaultLanguageId = LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault());
        }
        return defaultLanguageId;
    }

    public String getSmallImageType() throws PortalException, SystemException {
        if (this._smallImageType == null && this.isSmallImage()) {
            Image smallImage = ImageLocalServiceUtil.getImage((long)this.getSmallImageId());
            this._smallImageType = smallImage.getType();
        }
        return this._smallImageType;
    }

    public boolean isTemplateDriven() {
        return !Validator.isNull((String)this.getStructureId());
    }

    public void setSmallImageType(String smallImageType) {
        this._smallImageType = smallImageType;
    }
}

