/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.util;

import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGFolderLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.IGFolderServiceUtil;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletURL;

public class IGIndexer
extends BaseIndexer {
    public static final String[] CLASS_NAMES = new String[]{IGImage.class.getName()};
    public static final String PORTLET_ID = "31";

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)document.get("description"), (int)200);
        }
        String imageId = document.get("entryClassPK");
        portletURL.setParameter("struts_action", "/image_gallery/view_image");
        portletURL.setParameter("imageId", imageId);
        return new Summary(title, content, portletURL);
    }

    protected void checkSearchFolderId(long folderId, SearchContext searchContext) throws Exception {
        if (folderId == 0L) {
            return;
        }
        IGFolderServiceUtil.getFolder((long)folderId);
    }

    protected void doDelete(Object obj) throws Exception {
        IGImage image = (IGImage)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, image.getImageId());
        SearchEngineUtil.deleteDocument((long)image.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        IGImage image = (IGImage)obj;
        long companyId = image.getCompanyId();
        long groupId = this.getParentGroupId(image.getGroupId());
        long scopeGroupId = image.getGroupId();
        long userId = image.getUserId();
        long folderId = image.getFolderId();
        long imageId = image.getImageId();
        String name = image.getName();
        String description = image.getDescription();
        Date modifiedDate = image.getModifiedDate();
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)IGImage.class.getName(), (long)imageId);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)IGImage.class.getName(), (long)imageId);
        ExpandoBridge expandoBridge = image.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, imageId);
        document.addModifiedDate(modifiedDate);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("groupId", groupId);
        document.addKeyword("scopeGroupId", scopeGroupId);
        document.addKeyword("userId", userId);
        document.addText("title", name);
        document.addText("description", description);
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("folderId", folderId);
        document.addKeyword("entryClassName", IGImage.class.getName());
        document.addKeyword("entryClassPK", imageId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        IGImage image = (IGImage)obj;
        Document document = this.getDocument(image);
        SearchEngineUtil.updateDocument((long)image.getCompanyId(), (Document)document);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        IGImage image = IGImageLocalServiceUtil.getImage((long)classPK);
        this.doReindex(image);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexFolders(companyId);
        this.reindexRoot(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void reindexFolders(long companyId) throws Exception {
        int folderCount = IGFolderLocalServiceUtil.getCompanyFoldersCount((long)companyId);
        int folderPages = folderCount / 1000;
        int i = 0;
        while (i <= folderPages) {
            int folderStart = i * 1000;
            int folderEnd = folderStart + 1000;
            this.reindexFolders(companyId, folderStart, folderEnd);
            ++i;
        }
    }

    protected void reindexFolders(long companyId, int folderStart, int folderEnd) throws Exception {
        List folders = IGFolderLocalServiceUtil.getCompanyFolders((long)companyId, (int)folderStart, (int)folderEnd);
        for (IGFolder folder : folders) {
            long groupId = folder.getGroupId();
            long folderId = folder.getFolderId();
            int entryCount = IGImageLocalServiceUtil.getImagesCount((long)groupId, (long)folderId);
            int entryPages = entryCount / 1000;
            int i = 0;
            while (i <= entryPages) {
                int entryStart = i * 1000;
                int entryEnd = entryStart + 1000;
                this.reindexImages(companyId, groupId, folderId, entryStart, entryEnd);
                ++i;
            }
        }
    }

    protected void reindexImages(long companyId, long groupId, long folderId, int entryStart, int entryEnd) throws Exception {
        List images = IGImageLocalServiceUtil.getImages((long)groupId, (long)folderId, (int)entryStart, (int)entryEnd);
        if (images.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (IGImage image : images) {
            Document document = this.getDocument(image);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }

    protected void reindexRoot(long companyId) throws Exception {
        int groupCount = GroupLocalServiceUtil.getCompanyGroupsCount((long)companyId);
        int groupPages = groupCount / 1000;
        int i = 0;
        while (i <= groupPages) {
            int groupStart = i * 1000;
            int groupEnd = groupStart + 1000;
            this.reindexRoot(companyId, groupStart, groupEnd);
            ++i;
        }
    }

    protected void reindexRoot(long companyId, int groupStart, int groupEnd) throws Exception {
        List groups = GroupLocalServiceUtil.getCompanyGroups((long)companyId, (int)groupStart, (int)groupEnd);
        for (Group group : groups) {
            long groupId = group.getGroupId();
            long folderId = 0L;
            int entryCount = IGImageLocalServiceUtil.getImagesCount((long)groupId, (long)folderId);
            int entryPages = entryCount / 1000;
            int j = 0;
            while (j <= entryPages) {
                int entryStart = j * 1000;
                int entryEnd = entryStart + 1000;
                this.reindexImages(companyId, groupId, folderId, entryStart, entryEnd);
                ++j;
            }
        }
    }
}

