/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.imagegallery.lar;

import com.liferay.portal.kernel.lar.BasePortletDataHandler;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.portal.kernel.lar.PortletDataHandlerControl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Image;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.persistence.ImageUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.imagegallery.DuplicateImageNameException;
import com.liferay.portlet.imagegallery.model.IGFolder;
import com.liferay.portlet.imagegallery.model.IGImage;
import com.liferay.portlet.imagegallery.service.IGFolderLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.IGImageLocalServiceUtil;
import com.liferay.portlet.imagegallery.service.persistence.IGFolderUtil;
import com.liferay.portlet.imagegallery.service.persistence.IGImageUtil;
import com.liferay.util.PwdGenerator;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;

public class IGPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final boolean _ALWAYS_EXPORTABLE = true;
    private static final String _NAMESPACE = "image_gallery";
    private static Log _log = LogFactoryUtil.getLog(IGPortletDataHandlerImpl.class);
    private static PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("image_gallery", "categories");
    private static PortletDataHandlerBoolean _foldersAndImages = new PortletDataHandlerBoolean("image_gallery", "folders-and-images", true, true);
    private static PortletDataHandlerBoolean _ratings = new PortletDataHandlerBoolean("image_gallery", "ratings");
    private static PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("image_gallery", "tags");

    public static void exportImage(PortletDataContext context, Element foldersElement, Element imagesElement, IGImage image, boolean checkDateRange) throws Exception {
        String path;
        if (checkDateRange && !context.isWithinDateRange(image.getModifiedDate())) {
            return;
        }
        if (foldersElement != null) {
            IGPortletDataHandlerImpl.exportParentFolder(context, foldersElement, image.getFolderId());
        }
        if (context.isPathNotProcessed(path = IGPortletDataHandlerImpl.getImagePath(context, image))) {
            Element imageElement = imagesElement.addElement("image");
            imageElement.addAttribute("path", path);
            imageElement.addAttribute("bin-path", IGPortletDataHandlerImpl.getImageBinPath(context, image));
            if (context.getBooleanParameter(_NAMESPACE, "categories")) {
                context.addAssetCategories(IGImage.class, image.getImageId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.addRatingsEntries(IGImage.class, image.getImageId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addAssetTags(IGImage.class, image.getImageId());
            }
            image.setUserUuid(image.getUserUuid());
            Image largeImage = ImageUtil.findByPrimaryKey((long)image.getLargeImageId());
            image.setImageType(largeImage.getType());
            context.addPermissions(IGImage.class, image.getImageId());
            context.addZipEntry(IGPortletDataHandlerImpl.getImageBinPath(context, image), largeImage.getTextObj());
            context.addZipEntry(path, (Object)image);
        }
    }

    public static String getImagePath(PortletDataContext context, IGImage image) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("31"));
        sb.append("/images/");
        sb.append(image.getImageId());
        sb.append(".xml");
        return sb.toString();
    }

    public static void importFolder(PortletDataContext context, Element folderElement) throws Exception {
        String path = folderElement.attributeValue("path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        IGFolder folder = (IGFolder)context.getZipEntryAsObject(path);
        IGPortletDataHandlerImpl.importFolder(context, folder);
    }

    public static void importImage(PortletDataContext context, Element imageElement) throws Exception {
        String path = imageElement.attributeValue("path");
        String binPath = imageElement.attributeValue("bin-path");
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        IGImage image = (IGImage)context.getZipEntryAsObject(path);
        IGPortletDataHandlerImpl.importImage(context, image, binPath);
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_foldersAndImages, _categories, _ratings, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_foldersAndImages, _categories, _ratings, _tags};
    }

    public boolean isAlwaysExportable() {
        return true;
    }

    public boolean isPublishToLiveByDefault() {
        return PropsValues.DL_PUBLISH_TO_LIVE_BY_DEFAULT;
    }

    protected static void importFolder(PortletDataContext context, IGFolder folder) throws Exception {
        long userId = context.getUserId(folder.getUserUuid());
        Map folderPKs = context.getNewPrimaryKeysMap(IGFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCreateDate(folder.getCreateDate());
        serviceContext.setModifiedDate(folder.getModifiedDate());
        serviceContext.setScopeGroupId(context.getScopeGroupId());
        if (parentFolderId != 0L && parentFolderId == folder.getParentFolderId()) {
            String path = IGPortletDataHandlerImpl.getImportFolderPath(context, parentFolderId);
            IGFolder parentFolder = (IGFolder)context.getZipEntryAsObject(path);
            IGPortletDataHandlerImpl.importFolder(context, parentFolder);
            parentFolderId = MapUtil.getLong((Map)folderPKs, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        }
        IGFolder importedFolder = null;
        if (context.isDataStrategyMirror()) {
            IGFolder existingFolder = IGFolderUtil.fetchByUUID_G((String)folder.getUuid(), (long)context.getScopeGroupId());
            if (existingFolder == null) {
                String name = IGPortletDataHandlerImpl.getFolderName(context.getCompanyId(), context.getScopeGroupId(), parentFolderId, folder.getName(), 2);
                serviceContext.setUuid(folder.getUuid());
                importedFolder = IGFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
            } else {
                importedFolder = IGFolderLocalServiceUtil.updateFolder((long)existingFolder.getFolderId(), (long)parentFolderId, (String)folder.getName(), (String)folder.getDescription(), (boolean)false, (ServiceContext)serviceContext);
            }
        } else {
            String name = IGPortletDataHandlerImpl.getFolderName(context.getCompanyId(), context.getScopeGroupId(), parentFolderId, folder.getName(), 2);
            importedFolder = IGFolderLocalServiceUtil.addFolder((long)userId, (long)parentFolderId, (String)name, (String)folder.getDescription(), (ServiceContext)serviceContext);
        }
        folderPKs.put(folder.getFolderId(), importedFolder.getFolderId());
        context.importPermissions(IGFolder.class, folder.getFolderId(), importedFolder.getFolderId());
    }

    protected static void importImage(PortletDataContext context, IGImage image, String binPath) throws Exception {
        long userId = context.getUserId(image.getUserUuid());
        Map folderPKs = context.getNewPrimaryKeysMap(IGFolder.class);
        long folderId = MapUtil.getLong((Map)folderPKs, (long)image.getFolderId(), (long)image.getFolderId());
        File imageFile = null;
        byte[] bytes = context.getZipEntryAsByteArray(binPath);
        if (bytes == null) {
            _log.error((Object)("Could not find image file for image " + image.getImageId()));
            return;
        }
        imageFile = File.createTempFile(String.valueOf(image.getPrimaryKey()), "." + image.getImageType());
        FileUtil.write((File)imageFile, (byte[])bytes);
        long[] assetCategoryIds = null;
        String[] assetTagNames = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            assetCategoryIds = context.getAssetCategoryIds(IGImage.class, image.getImageId());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            assetTagNames = context.getAssetTagNames(IGImage.class, image.getImageId());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAssetCategoryIds(assetCategoryIds);
        serviceContext.setAssetTagNames(assetTagNames);
        serviceContext.setCreateDate(image.getCreateDate());
        serviceContext.setModifiedDate(image.getModifiedDate());
        if (folderId != 0L && folderId == image.getFolderId()) {
            String path = IGPortletDataHandlerImpl.getImportFolderPath(context, folderId);
            IGFolder folder = (IGFolder)context.getZipEntryAsObject(path);
            IGPortletDataHandlerImpl.importFolder(context, folder);
            folderId = MapUtil.getLong((Map)folderPKs, (long)image.getFolderId(), (long)image.getFolderId());
        }
        IGImage importedImage = null;
        if (context.isDataStrategyMirror()) {
            IGImage existingImage = IGImageUtil.fetchByUUID_G((String)image.getUuid(), (long)context.getScopeGroupId());
            if (existingImage == null) {
                serviceContext.setUuid(image.getUuid());
                importedImage = IGImageLocalServiceUtil.addImage((long)userId, (long)context.getScopeGroupId(), (long)folderId, (String)image.getName(), (String)image.getDescription(), (File)imageFile, (String)image.getImageType(), (ServiceContext)serviceContext);
            } else {
                importedImage = IGImageLocalServiceUtil.updateImage((long)userId, (long)existingImage.getImageId(), (long)context.getScopeGroupId(), (long)folderId, (String)image.getName(), (String)image.getDescription(), (File)imageFile, (String)image.getImageType(), (ServiceContext)serviceContext);
            }
        } else {
            String name = image.getName();
            try {
                importedImage = IGImageLocalServiceUtil.addImage((long)userId, (long)context.getScopeGroupId(), (long)folderId, (String)name, (String)image.getDescription(), (File)imageFile, (String)image.getImageType(), (ServiceContext)serviceContext);
            }
            catch (DuplicateImageNameException duplicateImageNameException) {
                String[] nameParts = name.split("\\.", 2);
                name = String.valueOf(nameParts[0]) + PwdGenerator.getPassword();
                if (nameParts.length > 1) {
                    name = String.valueOf(name) + "." + nameParts[1];
                }
                importedImage = IGImageLocalServiceUtil.addImage((long)userId, (long)context.getScopeGroupId(), (long)folderId, (String)name, (String)image.getDescription(), (File)imageFile, (String)image.getImageType(), (ServiceContext)serviceContext);
            }
        }
        context.importPermissions(IGImage.class, image.getImageId(), importedImage.getImageId());
        if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
            context.importRatingsEntries(IGImage.class, image.getImageId(), importedImage.getImageId());
        }
        Map igImagePKs = context.getNewPrimaryKeysMap(IGImage.class);
        igImagePKs.put(image.getImageId(), importedImage.getImageId());
    }

    protected static void exportFolder(PortletDataContext context, Element foldersElement, Element imagesElement, IGFolder folder) throws Exception {
        if (context.isWithinDateRange(folder.getModifiedDate())) {
            IGPortletDataHandlerImpl.exportParentFolder(context, foldersElement, folder.getParentFolderId());
            String path = IGPortletDataHandlerImpl.getFolderPath(context, folder.getFolderId());
            if (context.isPathNotProcessed(path)) {
                Element folderElement = foldersElement.addElement("folder");
                folderElement.addAttribute("path", path);
                folder.setUserUuid(folder.getUserUuid());
                context.addPermissions(IGFolder.class, folder.getFolderId());
                context.addZipEntry(path, (Object)folder);
            }
        }
        List images = IGImageUtil.findByG_F((long)folder.getGroupId(), (long)folder.getFolderId());
        for (IGImage image : images) {
            IGPortletDataHandlerImpl.exportImage(context, foldersElement, imagesElement, image, true);
        }
    }

    protected static void exportParentFolder(PortletDataContext context, Element foldersElement, long folderId) throws Exception {
        if (folderId == 0L) {
            return;
        }
        IGFolder folder = IGFolderUtil.findByPrimaryKey((long)folderId);
        IGPortletDataHandlerImpl.exportParentFolder(context, foldersElement, folder.getParentFolderId());
        String path = IGPortletDataHandlerImpl.getFolderPath(context, folder.getFolderId());
        if (context.isPathNotProcessed(path)) {
            Element folderElement = foldersElement.addElement("folder");
            folderElement.addAttribute("path", path);
            folder.setUserUuid(folder.getUserUuid());
            context.addPermissions(IGFolder.class, folder.getFolderId());
            context.addZipEntry(path, (Object)folder);
        }
    }

    protected static String getFolderName(long companyId, long groupId, long parentFolderId, String name, int count) throws Exception {
        IGFolder folder = IGFolderUtil.fetchByG_P_N((long)groupId, (long)parentFolderId, (String)name);
        if (folder == null) {
            return name;
        }
        if (Pattern.matches(".* \\(\\d+\\)", name)) {
            int pos = name.lastIndexOf(" (");
            name = name.substring(0, pos);
        }
        StringBundler sb = new StringBundler(5);
        sb.append(name);
        sb.append(" ");
        sb.append("(");
        sb.append(count);
        sb.append(")");
        name = sb.toString();
        return IGPortletDataHandlerImpl.getFolderName(companyId, groupId, parentFolderId, name, ++count);
    }

    protected static String getFolderPath(PortletDataContext context, long folderId) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getPortletPath("31"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getImageBinPath(PortletDataContext context, IGImage image) {
        StringBundler sb = new StringBundler(5);
        sb.append(context.getPortletPath("31"));
        sb.append("/bin/");
        sb.append(image.getImageId());
        sb.append(".");
        sb.append(image.getImageType());
        return sb.toString();
    }

    protected static String getImportFolderPath(PortletDataContext context, long folderId) {
        StringBundler sb = new StringBundler(4);
        sb.append(context.getSourcePortletPath("31"));
        sb.append("/folders/");
        sb.append(folderId);
        sb.append(".xml");
        return sb.toString();
    }

    protected PortletPreferences doDeleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        if (!context.addPrimaryKey(IGPortletDataHandlerImpl.class, "deleteData")) {
            IGFolderLocalServiceUtil.deleteFolders((long)context.getScopeGroupId());
            IGImageLocalServiceUtil.deleteImages((long)context.getScopeGroupId(), (long)0L);
        }
        return null;
    }

    protected String doExportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws Exception {
        context.addPermissions("com.liferay.portlet.imagegallery", context.getScopeGroupId());
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("image-gallery");
        rootElement.addAttribute("group-id", String.valueOf(context.getScopeGroupId()));
        Element foldersElement = rootElement.addElement("folders");
        Element imagesElement = rootElement.addElement("images");
        List folders = IGFolderUtil.findByGroupId((long)context.getScopeGroupId());
        for (IGFolder folder : folders) {
            IGPortletDataHandlerImpl.exportFolder(context, foldersElement, imagesElement, folder);
        }
        List images = IGImageUtil.findByG_F((long)context.getScopeGroupId(), (long)0L);
        for (IGImage image : images) {
            IGPortletDataHandlerImpl.exportImage(context, null, imagesElement, image, true);
        }
        return document.formattedString();
    }

    protected PortletPreferences doImportData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws Exception {
        context.importPermissions("com.liferay.portlet.imagegallery", context.getSourceGroupId(), context.getScopeGroupId());
        Document document = SAXReaderUtil.read((String)data);
        Element rootElement = document.getRootElement();
        Element foldersElement = rootElement.element("folders");
        List folderElements = foldersElement.elements("folder");
        for (Element folderElement : folderElements) {
            String path = folderElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            IGFolder folder = (IGFolder)context.getZipEntryAsObject(path);
            IGPortletDataHandlerImpl.importFolder(context, folder);
        }
        Element imagesElement = rootElement.element("images");
        List imageElements = imagesElement.elements("image");
        for (Element imageElement : imageElements) {
            String path = imageElement.attributeValue("path");
            if (!context.isPathNotProcessed(path)) continue;
            IGImage image = (IGImage)context.getZipEntryAsObject(path);
            String binPath = imageElement.attributeValue("bin-path");
            IGPortletDataHandlerImpl.importImage(context, image, binPath);
        }
        return null;
    }
}

