/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.enterpriseadmin.util;

import com.liferay.portal.NoSuchCountryException;
import com.liferay.portal.NoSuchRegionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.ExpandoIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.Country;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Region;
import com.liferay.portal.model.User;
import com.liferay.portal.service.CountryServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.RegionServiceUtil;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.AssetTagLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletURL;

public class OrganizationIndexer
extends ExpandoIndexer {
    public static final String[] CLASS_NAMES = new String[]{Organization.class.getName()};
    public static final String PORTLET_ID = "126";
    private static Log _log = LogFactoryUtil.getLog(OrganizationIndexer.class);

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Summary getSummary(Document document, String snippet, PortletURL portletURL) {
        String title = document.get("name");
        String content = null;
        String organizationId = document.get("organzationId");
        portletURL.setParameter("struts_action", "/enterprise_admin/edit_organization");
        portletURL.setParameter("organizationId", organizationId);
        return new Summary(title, content, portletURL);
    }

    protected void doDelete(Object obj) throws Exception {
        Organization organization = (Organization)obj;
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, organization.getOrganizationId());
        SearchEngineUtil.deleteDocument((long)organization.getCompanyId(), (String)document.get("uid"));
    }

    protected Document doGetDocument(Object obj) throws Exception {
        ArrayList<String> countries;
        ArrayList<String> regions;
        ArrayList<String> zips;
        ArrayList<String> cities;
        ArrayList<String> streets;
        List addresses;
        String type;
        String name;
        long parentOrganizationId;
        long organizationId;
        long companyId;
        Organization organization;
        block8: {
            long countryId;
            block7: {
                organization = (Organization)obj;
                companyId = organization.getCompanyId();
                organizationId = organization.getOrganizationId();
                parentOrganizationId = organization.getParentOrganizationId();
                name = organization.getName();
                type = organization.getType();
                long regionId = organization.getRegionId();
                countryId = organization.getCountryId();
                addresses = organization.getAddresses();
                streets = new ArrayList<String>();
                cities = new ArrayList<String>();
                zips = new ArrayList<String>();
                regions = new ArrayList<String>();
                countries = new ArrayList<String>();
                if (regionId > 0L) {
                    try {
                        Region region = RegionServiceUtil.getRegion((long)regionId);
                        regions.add(region.getName().toLowerCase());
                    }
                    catch (NoSuchRegionException nsre) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Object)nsre.getMessage());
                    }
                }
            }
            if (countryId > 0L) {
                try {
                    Country country = CountryServiceUtil.getCountry((long)countryId);
                    countries.add(country.getName().toLowerCase());
                }
                catch (NoSuchCountryException nsce) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)nsce.getMessage());
                }
            }
        }
        for (Address address : addresses) {
            streets.add(address.getStreet1().toLowerCase());
            streets.add(address.getStreet2().toLowerCase());
            streets.add(address.getStreet3().toLowerCase());
            cities.add(address.getCity().toLowerCase());
            zips.add(address.getZip().toLowerCase());
            regions.add(address.getRegion().getName().toLowerCase());
            countries.add(address.getCountry().getName().toLowerCase());
        }
        long[] assetCategoryIds = AssetCategoryLocalServiceUtil.getCategoryIds((String)User.class.getName(), (long)organizationId);
        String[] assetTagNames = AssetTagLocalServiceUtil.getTagNames((String)User.class.getName(), (long)organizationId);
        ExpandoBridge expandoBridge = organization.getExpandoBridge();
        DocumentImpl document = new DocumentImpl();
        document.addUID(PORTLET_ID, organizationId);
        document.addKeyword("companyId", companyId);
        document.addKeyword("portletId", PORTLET_ID);
        document.addKeyword("organzationId", organizationId);
        document.addKeyword("parentOrganizationId", parentOrganizationId);
        document.addKeyword("name", name, true);
        document.addKeyword("type", type);
        document.addKeyword("street", streets.toArray(new String[streets.size()]));
        document.addKeyword("city", cities.toArray(new String[cities.size()]));
        document.addKeyword("zip", zips.toArray(new String[zips.size()]));
        document.addKeyword("region", regions.toArray(new String[regions.size()]));
        document.addKeyword("country", countries.toArray(new String[countries.size()]));
        document.addKeyword("assetCategoryIds", assetCategoryIds);
        document.addKeyword("assetTagNames", assetTagNames);
        document.addKeyword("entryClassName", Organization.class.getName());
        document.addKeyword("entryClassPK", organizationId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)document, (ExpandoBridge)expandoBridge);
        return document;
    }

    protected void doReindex(Object obj) throws Exception {
        if (obj instanceof List) {
            List organizations = (List)obj;
            for (Organization organization : organizations) {
                this.doReindex(organization);
            }
        } else if (obj instanceof Long) {
            long organizationId = (Long)obj;
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            this.doReindex(organization);
        } else if (obj instanceof long[]) {
            long[] organizationIds = (long[])obj;
            HashMap<Long, ArrayList<Document>> documentsMap = new HashMap<Long, ArrayList<Document>>();
            long[] lArray = organizationIds;
            int n = organizationIds.length;
            int n2 = 0;
            while (n2 < n) {
                long organizationId = lArray[n2];
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                Document document = this.getDocument(organization);
                long companyId = organization.getCompanyId();
                ArrayList<Document> documents = (ArrayList<Document>)documentsMap.get(companyId);
                if (documents == null) {
                    documents = new ArrayList<Document>();
                    documentsMap.put(companyId, documents);
                }
                documents.add(document);
                ++n2;
            }
            for (Map.Entry entry : documentsMap.entrySet()) {
                long companyId = (Long)entry.getKey();
                Collection documents = (Collection)entry.getValue();
                SearchEngineUtil.updateDocuments((long)companyId, (Collection)documents);
            }
        } else if (obj instanceof Organization) {
            Organization organization = (Organization)obj;
            Document document = this.getDocument(organization);
            SearchEngineUtil.updateDocument((long)organization.getCompanyId(), (Document)document);
        }
    }

    protected void doReindex(String className, long classPK) throws Exception {
        Organization organization = OrganizationLocalServiceUtil.getOrganization((long)classPK);
        this.doReindex(organization);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexOrganizations(companyId);
    }

    protected String getPortletId(SearchContext searchContext) {
        return PORTLET_ID;
    }

    protected void postProcessSearchQuery(BooleanQuery searchQuery, SearchContext searchContext) throws Exception {
        String zip;
        String type;
        String street;
        String region;
        String parentOrganizationId;
        LinkedHashMap params;
        String name;
        String country;
        String city = (String)((Object)searchContext.getAttribute("city"));
        if (Validator.isNotNull((String)city)) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("city", city, true);
            } else {
                searchQuery.addTerm("city", city, true);
            }
        }
        if (Validator.isNotNull((String)(country = (String)((Object)searchContext.getAttribute("country"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("country", country, true);
            } else {
                searchQuery.addTerm("country", country, true);
            }
        }
        if (Validator.isNotNull((String)(name = (String)((Object)searchContext.getAttribute("name"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("name", name, true);
            } else {
                searchQuery.addTerm("name", name, true);
            }
        }
        if ((params = (LinkedHashMap)searchContext.getAttribute("params")) != null) {
            ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)searchContext.getCompanyId(), (String)Organization.class.getName());
            Set attributeNames = SetUtil.fromEnumeration((Enumeration)expandoBridge.getAttributeNames());
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.addSearchQueryParams(searchQuery, searchContext, expandoBridge, attributeNames, key, value);
            }
        }
        if (Validator.isNotNull((String)(parentOrganizationId = (String)((Object)searchContext.getAttribute("parentOrganizationId"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("parentOrganizationId", parentOrganizationId, true);
            } else {
                searchQuery.addTerm("parentOrganizationId", parentOrganizationId, true);
            }
        }
        if (Validator.isNotNull((String)(region = (String)((Object)searchContext.getAttribute("region"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("region", region, true);
            } else {
                searchQuery.addTerm("region", region, true);
            }
        }
        if (Validator.isNotNull((String)(street = (String)((Object)searchContext.getAttribute("street"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("street", street, true);
            } else {
                searchQuery.addTerm("street", street, true);
            }
        }
        if (Validator.isNotNull((String)(type = (String)((Object)searchContext.getAttribute("type"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("type", type, true);
            } else {
                searchQuery.addTerm("type", type, true);
            }
        }
        if (Validator.isNotNull((String)(zip = (String)((Object)searchContext.getAttribute("zip"))))) {
            if (searchContext.isAndSearch()) {
                searchQuery.addRequiredTerm("zip", zip, true);
            } else {
                searchQuery.addTerm("zip", zip, true);
            }
        }
    }

    protected void reindexOrganizations(long companyId) throws Exception {
        int count = OrganizationLocalServiceUtil.getOrganizationsCount();
        int pages = count / 1000;
        int i = 0;
        while (i <= pages) {
            int start = i * 1000;
            int end = start + 1000;
            this.reindexOrganizations(companyId, start, end);
            ++i;
        }
    }

    protected void reindexOrganizations(long companyId, int start, int end) throws Exception {
        List organizations = OrganizationLocalServiceUtil.getOrganizations((int)start, (int)end);
        if (organizations.isEmpty()) {
            return;
        }
        ArrayList<Document> documents = new ArrayList<Document>();
        for (Organization organization : organizations) {
            Document document = this.getDocument(organization);
            documents.add(document);
        }
        SearchEngineUtil.updateDocuments((long)companyId, documents);
    }
}

