/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Lock;
import com.liferay.portal.security.auth.HttpPrincipal;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.http.TunnelUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import java.io.File;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLFileEntryServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(DLFileEntryServiceHttp.class);

    public static DLFileEntry addFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String title, String description, String changeLog, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "addFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class, byte[].class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, title, description, changeLog, extraSettings, bytes, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFileEntry addFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String title, String description, String changeLog, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "addFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class, File.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, title, description, changeLog, extraSettings, file, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "deleteFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String version) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "deleteFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, version});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteFileEntryByTitle(HttpPrincipal httpPrincipal, long groupId, long folderId, String titleWithExtension) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "deleteFileEntryByTitle", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, titleWithExtension});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<DLFileEntry> getFileEntries(HttpPrincipal httpPrincipal, long groupId, long folderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getFileEntries", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<DLFileEntry> getFileEntries(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getFileEntries", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<DLFileEntry> getFileEntries(HttpPrincipal httpPrincipal, long groupId, long folderId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getFileEntries", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFileEntriesCount(HttpPrincipal httpPrincipal, long groupId, long folderId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getFileEntriesCount", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFileEntry getFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFileEntry getFileEntryByTitle(HttpPrincipal httpPrincipal, long groupId, long folderId, String titleWithExtension) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getFileEntryByTitle", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, titleWithExtension});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFileEntry getFileEntryByUuidAndGroupId(HttpPrincipal httpPrincipal, String uuid, long groupId) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getFileEntryByUuidAndGroupId", new Class[]{String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{uuid, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getFoldersFileEntriesCount(HttpPrincipal httpPrincipal, long groupId, List<Long> folderIds, int status) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getFoldersFileEntriesCount", new Class[]{Long.TYPE, List.class, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderIds, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<DLFileEntry> getGroupFileEntries(HttpPrincipal httpPrincipal, long groupId, long userId, int start, int end) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getGroupFileEntries", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<DLFileEntry> getGroupFileEntries(HttpPrincipal httpPrincipal, long groupId, long userId, int start, int end, OrderByComparator obc) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getGroupFileEntries", new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getGroupFileEntriesCount(HttpPrincipal httpPrincipal, long groupId, long userId) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "getGroupFileEntriesCount", new Class[]{Long.TYPE, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasFileEntryLock(HttpPrincipal httpPrincipal, long groupId, long folderId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "hasFileEntryLock", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Lock lockFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "lockFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Lock)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Lock lockFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String owner, long expirationTime) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "lockFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, owner, expirationTime});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Lock)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFileEntry moveFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, long newFolderId, String name, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "moveFileEntry", new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, String.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, newFolderId, name, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Lock refreshFileEntryLock(HttpPrincipal httpPrincipal, String lockUuid, long expirationTime) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "refreshFileEntryLock", new Class[]{String.class, Long.TYPE});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{lockUuid, expirationTime});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Lock)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unlockFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name) throws SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "unlockFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void unlockFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String lockUuid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "unlockFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, lockUuid});
            try {
                TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFileEntry updateFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String sourceFileName, String title, String description, String changeLog, boolean majorVersion, String extraSettings, byte[] bytes, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "updateFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class, Boolean.TYPE, String.class, byte[].class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, sourceFileName, title, description, changeLog, majorVersion, extraSettings, bytes, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static DLFileEntry updateFileEntry(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String sourceFileName, String title, String description, String changeLog, boolean majorVersion, String extraSettings, File file, ServiceContext serviceContext) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "updateFileEntry", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, String.class, String.class, String.class, Boolean.TYPE, String.class, File.class, ServiceContext.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, sourceFileName, title, description, changeLog, majorVersion, extraSettings, file, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (DLFileEntry)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean verifyFileEntryLock(HttpPrincipal httpPrincipal, long groupId, long folderId, String name, String lockUuid) throws PortalException, SystemException {
        try {
            MethodKey methodKey = new MethodKey(DLFileEntryServiceUtil.class.getName(), "verifyFileEntryLock", new Class[]{Long.TYPE, Long.TYPE, String.class, String.class});
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, folderId, name, lockUuid});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke(httpPrincipal, methodHandler);
            }
            catch (Exception e) {
                if (e instanceof PortalException) {
                    throw (PortalException)((Object)e);
                }
                if (e instanceof SystemException) {
                    throw (SystemException)((Object)e);
                }
                throw new SystemException((Throwable)e);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

