/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryAssetRenderer;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class DLFileEntryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String CLASS_NAME = DLFileEntry.class.getName();
    public static final String TYPE = "document";

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        DLFileEntry fileEntry = null;
        DLFileVersion fileVersion = null;
        try {
            fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)classPK);
            fileVersion = type == 0 ? fileEntry.getLatestFileVersion() : fileEntry.getFileVersion();
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            fileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)classPK);
            fileEntry = fileVersion.getFileEntry();
        }
        return new DLFileEntryAssetRenderer(fileEntry, fileVersion);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("THEME_DISPLAY");
        LiferayPortletURL addAssetURL = null;
        if (DLPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_DOCUMENT")) {
            addAssetURL = liferayPortletResponse.createRenderURL("20");
            addAssetURL.setParameter("struts_action", "/document_library/edit_file_entry");
            addAssetURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
            addAssetURL.setParameter("folderId", String.valueOf(AssetPublisherUtil.getRecentFolderId((PortletRequest)liferayPortletRequest, CLASS_NAME)));
            addAssetURL.setParameter("uploader", "classic");
        }
        return addAssetURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, classPK, actionId);
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/clip.png";
    }
}

