/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileVersionLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetFileAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    public ActionForward strutsExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
            String name = ParamUtil.getString((HttpServletRequest)request, (String)"name");
            String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
            String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
            long fileShortcutId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileShortcutId");
            String uuid = ParamUtil.getString((HttpServletRequest)request, (String)"uuid");
            String targetExtension = ParamUtil.getString((HttpServletRequest)request, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId", (long)themeDisplay.getScopeGroupId());
            this.getFile(folderId, name, title, version, fileShortcutId, uuid, groupId, targetExtension, themeDisplay, request, response);
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
            String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
            String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
            String version = ParamUtil.getString((PortletRequest)actionRequest, (String)"version");
            long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
            String uuid = ParamUtil.getString((PortletRequest)actionRequest, (String)"uuid");
            String targetExtension = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            this.getFile(folderId, name, title, version, fileShortcutId, uuid, groupId, targetExtension, themeDisplay, request, response);
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfee), (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    protected void getFile(long folderId, String name, String title, String version, long fileShortcutId, String uuid, long groupId, String targetExtension, ThemeDisplay themeDisplay, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String sourceExtension;
        String id;
        InputStream convertedIS;
        long companyId = themeDisplay.getCompanyId();
        long userId = themeDisplay.getUserId();
        if (name.startsWith("DLFE-")) {
            name = name.substring("DLFE-".length());
        }
        name = FileUtil.stripExtension((String)name);
        DLFileEntry fileEntry = null;
        if (Validator.isNotNull((String)uuid) && groupId > 0L) {
            try {
                fileEntry = DLFileEntryServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
                folderId = fileEntry.getFolderId();
                name = fileEntry.getName();
            }
            catch (Exception exception) {}
        }
        if (fileShortcutId <= 0L) {
            if (Validator.isNotNull((String)name)) {
                fileEntry = DLFileEntryServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)name);
                title = fileEntry.getTitle();
            } else if (Validator.isNotNull((String)title)) {
                fileEntry = DLFileEntryServiceUtil.getFileEntryByTitle((long)groupId, (long)folderId, (String)title);
                name = fileEntry.getName();
            }
        } else {
            DLFileShortcut fileShortcut = DLFileShortcutServiceUtil.getFileShortcut((long)fileShortcutId);
            folderId = fileShortcut.getToFolderId();
            name = fileShortcut.getToName();
            fileEntry = DLFileEntryLocalServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)name);
        }
        if (Validator.isNull((String)version)) {
            if (Validator.isNotNull((String)fileEntry.getVersion())) {
                version = fileEntry.getVersion();
            } else {
                throw new NoSuchFileEntryException();
            }
        }
        InputStream is = DLFileEntryLocalServiceUtil.getFileAsStream((long)companyId, (long)userId, (long)groupId, (long)folderId, (String)name, (String)version);
        boolean converted = false;
        String fileName = fileEntry.getTitle();
        if (Validator.isNotNull((String)targetExtension) && (convertedIS = DocumentConversionUtil.convert(id = DocumentConversionUtil.getTempFileId(fileEntry.getFileEntryId(), version), is, sourceExtension = FileUtil.getExtension((String)fileName), targetExtension)) != null && convertedIS != is) {
            fileName = FileUtil.stripExtension((String)fileEntry.getTitle()).concat(".").concat(targetExtension);
            is = convertedIS;
            converted = true;
        }
        int contentLength = 0;
        if (!converted) {
            if (DLUtil.compareVersions((String)version, (String)fileEntry.getVersion()) >= 0) {
                contentLength = (int)fileEntry.getSize();
            } else {
                DLFileVersion fileVersion = DLFileVersionLocalServiceUtil.getFileVersion((long)groupId, (long)folderId, (String)name, (String)version);
                contentLength = (int)fileVersion.getSize();
            }
        }
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (int)contentLength, (String)contentType);
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }
}

