/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.communities.messaging;

import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageStatus;
import com.liferay.portal.kernel.messaging.sender.MessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.communities.messaging.LayoutsLocalPublisherRequest;
import java.util.Date;
import java.util.Map;

public class LayoutsLocalPublisherMessageListener
extends BaseMessageListener {
    public LayoutsLocalPublisherMessageListener() {
    }

    public LayoutsLocalPublisherMessageListener(SingleDestinationMessageSender statusSender, MessageSender responseSender) {
        super(statusSender, responseSender);
    }

    protected void doReceive(Message message, MessageStatus messageStatus) throws Exception {
        int last;
        LayoutsLocalPublisherRequest publisherRequest = (LayoutsLocalPublisherRequest)message.getPayload();
        messageStatus.setPayload((Object)publisherRequest);
        String command = publisherRequest.getCommand();
        long userId = publisherRequest.getUserId();
        long sourceGroupId = publisherRequest.getSourceGroupId();
        long targetGroupId = publisherRequest.getTargetGroupId();
        boolean privateLayout = publisherRequest.isPrivateLayout();
        Map<Long, Boolean> layoutIdMap = publisherRequest.getLayoutIdMap();
        Map<String, String[]> parameterMap = publisherRequest.getParameterMap();
        Date startDate = publisherRequest.getStartDate();
        Date endDate = publisherRequest.getEndDate();
        String range = MapUtil.getString(parameterMap, (String)"range");
        if (range.equals("last") && (last = MapUtil.getInteger(parameterMap, (String)"last")) > 0) {
            Date scheduledFireTime = publisherRequest.getScheduledFireTime();
            startDate = new Date(scheduledFireTime.getTime() - (long)last * 3600000L);
            endDate = scheduledFireTime;
        }
        PrincipalThreadLocal.setName((long)userId);
        User user = UserLocalServiceUtil.getUserById((long)userId);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user, (boolean)false);
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        try {
            if (command.equals("ALL_PAGES")) {
                StagingUtil.publishLayouts((long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, parameterMap, (Date)startDate, (Date)endDate);
            } else if (command.equals("SELECTED_PAGES")) {
                StagingUtil.publishLayouts((long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (Date)startDate, (Date)endDate);
            }
        }
        finally {
            PrincipalThreadLocal.setName(null);
            PermissionThreadLocal.setPermissionChecker(null);
        }
    }
}

