/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.blogs.model.BlogsStatsUser;
import com.liferay.portlet.blogs.model.impl.BlogsStatsUserImpl;
import com.liferay.portlet.blogs.service.persistence.BlogsStatsUserFinder;
import com.liferay.portlet.blogs.service.persistence.BlogsStatsUserUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlogsStatsUserFinderImpl
extends BasePersistenceImpl<BlogsStatsUser>
implements BlogsStatsUserFinder {
    public static String COUNT_BY_ORGANIZATION_IDS = String.valueOf(BlogsStatsUserFinder.class.getName()) + ".countByOrganizationIds";
    public static String FIND_BY_GROUP_IDS = String.valueOf(BlogsStatsUserFinder.class.getName()) + ".findByGroupIds";
    public static String FIND_BY_ORGANIZATION_IDS = String.valueOf(BlogsStatsUserFinder.class.getName()) + ".findByOrganizationIds";

    public int countByOrganizationId(long organizationId) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.countByOrganizationIds(organizationIds);
    }

    public int countByOrganizationIds(List<Long> organizationIds) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i = 0;
            while (i < organizationIds.size()) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
                ++i;
            }
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsStatsUser> findByGroupIds(long companyId, long groupId, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_GROUP_IDS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("userId", Type.LONG);
            q.addScalar("lastPostDate", Type.TIMESTAMP);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(groupId);
            qPos.add(groupId);
            qPos.add(groupId);
            ArrayList<BlogsStatsUser> statsUsers = new ArrayList<BlogsStatsUser>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            while (itr.hasNext()) {
                Date lastPostDate;
                Object[] array = (Object[])itr.next();
                long userId = (Long)array[0];
                List curStatsUsers = BlogsStatsUserUtil.findByU_L((long)userId, (Date)(lastPostDate = (Date)array[1]));
                if (curStatsUsers.isEmpty()) continue;
                BlogsStatsUser statsUser = (BlogsStatsUser)curStatsUsers.get(0);
                statsUsers.add(statsUser);
            }
            ArrayList<BlogsStatsUser> arrayList = statsUsers;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsStatsUser> findByOrganizationId(long organizationId, int start, int end, OrderByComparator obc) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.findByOrganizationIds(organizationIds, start, end, obc);
    }

    public List<BlogsStatsUser> findByOrganizationIds(List<Long> organizationIds, int start, int end, OrderByComparator obc) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORGANIZATION_IDS);
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)obc);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsStatsUser", BlogsStatsUserImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i = 0;
            while (i < organizationIds.size()) {
                Long organizationId = organizationIds.get(i);
                qPos.add(organizationId);
                ++i;
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        if (organizationIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(organizationIds.size() * 2 - 1);
        int i = 0;
        while (i < organizationIds.size()) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i + 1 != organizationIds.size()) {
                sb.append("OR ");
            }
            ++i;
        }
        return sb.toString();
    }
}

