/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.verify.VerifyException;
import java.io.IOException;
import java.sql.SQLException;
import javax.naming.NamingException;

public abstract class VerifyProcess {
    public static final int ALWAYS = -1;
    public static final int NEVER = 0;
    public static final int ONCE = 1;
    private static Log _log = LogFactoryUtil.getLog(VerifyProcess.class);

    public void runSQL(String template) throws IOException, SQLException {
        DB db = DBFactoryUtil.getDB();
        db.runSQL(template);
    }

    public void runSQL(String[] templates) throws IOException, SQLException {
        DB db = DBFactoryUtil.getDB();
        db.runSQL(templates);
    }

    public void runSQLTemplate(String path) throws IOException, NamingException, SQLException {
        DB db = DBFactoryUtil.getDB();
        db.runSQLTemplate(path);
    }

    public void runSQLTemplate(String path, boolean failOnError) throws IOException, NamingException, SQLException {
        DB db = DBFactoryUtil.getDB();
        db.runSQLTemplate(path, failOnError);
    }

    public void verify() throws VerifyException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Verifying " + this.getClass().getName()));
            }
            this.doVerify();
        }
        catch (Exception e) {
            throw new VerifyException(e);
        }
    }

    public void verify(VerifyProcess verifyProcess) throws VerifyException {
        verifyProcess.verify();
    }

    protected void doVerify() throws Exception {
    }
}

