/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.upload.LiferayFileUpload;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.portlet.ActionRequest;
import javax.portlet.PortletSession;

public class ProgressInputStream
extends InputStream {
    private static final int _DEFAULT_INITIAL_BUFFER_SIZE = 4096;
    private static Log _log = LogFactoryUtil.getLog(ProgressInputStream.class);
    private PortletSession _portletSession;
    private InputStream _is;
    private long _totalRead;
    private long _totalSize;
    private String _progressId;

    public ProgressInputStream(ActionRequest actionRequest, InputStream is, long totalSize, String progressId) {
        this._portletSession = actionRequest.getPortletSession();
        this._is = is;
        this._totalSize = totalSize;
        this._progressId = progressId;
        this.initProgress();
    }

    public int available() throws IOException {
        return this._is.available();
    }

    public void clearProgress() {
        this._portletSession.removeAttribute(this._getPercentAttributeName());
    }

    public void close() throws IOException {
        this._is.close();
    }

    public long getTotalRead() {
        return this._totalRead;
    }

    public void initProgress() {
        this._portletSession.setAttribute(this._getPercentAttributeName(), (Object)new Integer(0), 1);
    }

    public void mark(int readlimit) {
        this._is.mark(readlimit);
    }

    public boolean markSupported() {
        return this._is.markSupported();
    }

    public int read() throws IOException {
        return this._is.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        this._updateProgress(bytesRead);
        return bytesRead;
    }

    public void readAll(OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        while ((len = this.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        os.close();
    }

    public void reset() throws IOException {
        this._is.reset();
    }

    public long skip(long n) throws IOException {
        long result = this._is.skip(n);
        this._updateProgress(result);
        return result;
    }

    private String _getPercentAttributeName() {
        return String.valueOf(LiferayFileUpload.PERCENT) + this._progressId;
    }

    private void _updateProgress(long bytesRead) {
        Integer curPercent;
        this._totalRead = bytesRead > 0L ? (this._totalRead += bytesRead) : this._totalSize;
        int percent = (int)(this._totalRead * 100L / this._totalSize);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(String.valueOf(bytesRead) + "/" + this._totalRead + "=" + percent));
        }
        if ((curPercent = (Integer)this._portletSession.getAttribute(this._getPercentAttributeName(), 1)) == null || percent - curPercent >= 1) {
            this._portletSession.setAttribute(this._getPercentAttributeName(), (Object)new Integer(percent), 1);
        }
    }
}

