/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v4_3_0.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.util.BaseUpgradeColumnImpl;
import com.liferay.portal.kernel.upgrade.util.UpgradeColumn;
import com.liferay.portal.kernel.upgrade.util.ValueMapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.upgrade.v4_3_0.util.ClassPKContainer;
import com.liferay.portal.upgrade.v4_3_0.util.ResourceCodeIdUpgradeColumnImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePrimKeyUpgradeColumnImpl
extends BaseUpgradeColumnImpl {
    private static Log _log = LogFactoryUtil.getLog(ResourcePrimKeyUpgradeColumnImpl.class);
    private UpgradeColumn _nameColumn;
    private ResourceCodeIdUpgradeColumnImpl _codeIdColumn;
    private ValueMapper _groupIdMapper;
    private Map<Long, ClassPKContainer> _classPKContainers;
    private ValueMapper _layoutPlidMapper;

    public ResourcePrimKeyUpgradeColumnImpl(UpgradeColumn nameColumn, ResourceCodeIdUpgradeColumnImpl codeIdColumn, ValueMapper groupIdMapper, Map<Long, ClassPKContainer> classPKContainers, ValueMapper layoutPlidMapper) {
        super("primKey");
        this._nameColumn = nameColumn;
        this._codeIdColumn = codeIdColumn;
        this._groupIdMapper = groupIdMapper;
        this._classPKContainers = classPKContainers;
        this._layoutPlidMapper = layoutPlidMapper;
    }

    public Object getNewValue(Object oldValue) throws Exception {
        String primKey = (String)oldValue;
        int scope = this._codeIdColumn.getScope();
        if (scope == 1) {
            return primKey;
        }
        if (scope == 2) {
            return String.valueOf(this._groupIdMapper.getNewValue((Object)new Long(GetterUtil.getLong((String)primKey))));
        }
        if (scope == 4) {
            String name = (String)this._nameColumn.getOldValue();
            if (name.startsWith("com.liferay.")) {
                primKey = this.getClassPKPrimKey(name, primKey);
            } else if (primKey.indexOf("_LAYOUT_") > 0 && (primKey.startsWith("PUB.") || primKey.startsWith("PRI."))) {
                primKey = this.getLayoutPrimKey(primKey);
            }
            return primKey;
        }
        throw new UpgradeException("Scope " + scope + " is invalid");
    }

    protected String getClassPKPrimKey(String name, String primKey) throws Exception {
        Long classNameId = new Long(PortalUtil.getClassNameId((String)name));
        ClassPKContainer classPKContainer = this._classPKContainers.get(classNameId);
        if (classPKContainer != null) {
            ValueMapper valueMapper = classPKContainer.getValueMapper();
            if (valueMapper == null) {
                _log.error((Object)("Name " + name + " does not have a value mapper"));
            } else {
                primKey = classPKContainer.isLong() ? String.valueOf(valueMapper.getNewValue((Object)new Long(GetterUtil.getLong((String)primKey)))) : String.valueOf(valueMapper.getNewValue((Object)primKey));
            }
        } else {
            _log.error((Object)("Name " + name + " is invalid"));
        }
        return primKey;
    }

    protected String getLayoutPrimKey(String oldPrimKey) throws Exception {
        int x = oldPrimKey.indexOf(46, 4);
        int y = oldPrimKey.indexOf("_LAYOUT_");
        String oldOwnerId = oldPrimKey.substring(0, x);
        String layoutId = oldPrimKey.substring(x + 1, y);
        String oldPlidValue = "{layoutId=" + layoutId + ", ownerId=" + oldOwnerId + "}";
        Object newPlid = this._layoutPlidMapper.getNewValue((Object)oldPlidValue);
        String newPrimKey = newPlid + oldPrimKey.substring(y);
        return newPrimKey;
    }
}

