/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.tools.ant.DirectoryScanner;

public class PluginsEnvironmentBuilder {
    private static final String _SVN_ADD = "svn add ";
    private static final String _SVN_DEL_IGNORES = "svn propdel svn:ignore ";
    private static final String _SVN_GET_IGNORES = "svn propget svn:ignore ";
    private static final String _SVN_INFO = "svn info ";
    private static final String _SVN_SET_IGNORES = "svn propset svn:ignore ";
    private boolean _svn;

    public static void main(String[] args) throws Exception {
        InitUtil.initWithSpring();
        File dir = new File(System.getProperty("plugins.env.dir"));
        boolean svn = GetterUtil.getBoolean((String)System.getProperty("plugins.env.svn"));
        boolean eclipse = GetterUtil.getBoolean((String)System.getProperty("plugins.env.eclipse"));
        new PluginsEnvironmentBuilder(dir, svn, eclipse);
    }

    public PluginsEnvironmentBuilder(File dir, boolean svn, boolean eclipse) {
        try {
            String[] fileNames;
            this._svn = svn;
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(dir);
            ds.setIncludes(new String[]{"**\\liferay-plugin-package.properties"});
            ds.scan();
            String dirName = dir.getCanonicalPath();
            String[] stringArray = fileNames = ds.getIncludedFiles();
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File propertiesFile = new File(String.valueOf(dirName) + "/" + fileName);
                File libDir = new File(String.valueOf(propertiesFile.getParent()) + "/lib");
                File projectDir = new File(String.valueOf(propertiesFile.getParent()) + "/../..");
                Properties properties = new Properties();
                properties.load(new FileInputStream(propertiesFile));
                Object[] dependencyJars = StringUtil.split((String)properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars")));
                if (svn) {
                    List jars = ListUtil.toList((Object[])dependencyJars);
                    jars.add("commons-logging.jar");
                    jars.add("log4j.jar");
                    jars.add("util-bridges.jar");
                    jars.add("util-java.jar");
                    jars.add("util-taglib.jar");
                    jars = ListUtil.sort((List)jars);
                    this.updateLibIgnores(libDir, jars.toArray(new String[jars.size()]));
                }
                if (eclipse) {
                    this.updateEclipseFiles(libDir, projectDir, (String[])dependencyJars);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateEclipseFiles(File libDir, File projectDir, String[] dependencyJars) throws Exception {
        String libDirPath = libDir.getPath();
        libDirPath = StringUtil.replace((String)libDirPath, (String)"\\", (String)"/");
        String projectDirName = projectDir.getCanonicalPath();
        String projectName = StringUtil.extractLast((String)projectDirName, (String)File.separator);
        boolean javaProject = false;
        if (FileUtil.exists((String)(String.valueOf(projectDirName) + "/docroot/WEB-INF/src"))) {
            javaProject = true;
        }
        StringBundler sb = new StringBundler(17);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        sb.append("<projectDescription>\n");
        sb.append("\t<name>");
        sb.append(projectName);
        sb.append("</name>\n");
        sb.append("\t<comment></comment>\n");
        sb.append("\t<projects></projects>\n");
        sb.append("\t<buildSpec>\n");
        if (javaProject) {
            sb.append("\t\t<buildCommand>\n");
            sb.append("\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\n");
            sb.append("\t\t\t<arguments></arguments>\n");
            sb.append("\t\t</buildCommand>\n");
        }
        sb.append("\t</buildSpec>\n");
        sb.append("\t<natures>\n");
        if (javaProject) {
            sb.append("\t\t<nature>org.eclipse.jdt.core.javanature</nature>\n");
        }
        sb.append("\t</natures>\n");
        sb.append("</projectDescription>");
        File projectFile = new File(String.valueOf(projectDirName) + "/.project");
        System.out.println("Updating " + projectFile);
        FileUtil.write((File)projectFile, (String)sb.toString());
        File classpathFile = null;
        if (javaProject) {
            List portalJars = ListUtil.toList((Object[])dependencyJars);
            portalJars.add("commons-logging.jar");
            portalJars.add("log4j.jar");
            portalJars = ListUtil.sort((List)portalJars);
            Object[] customJarsArray = libDir.list((FilenameFilter)new GlobFilenameFilter("*.jar"));
            List customJars = null;
            if (customJarsArray != null) {
                customJars = ListUtil.toList((Object[])customJarsArray);
                customJars = ListUtil.sort(customJars);
                for (String jar : portalJars) {
                    customJars.remove(jar);
                }
                customJars.remove(String.valueOf(projectName) + "-service.jar");
                customJars.remove("util-bridges.jar");
                customJars.remove("util-java.jar");
                customJars.remove("util-taglib.jar");
            } else {
                customJars = new ArrayList();
            }
            sb = new StringBundler();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
            sb.append("<classpath>\n");
            if (FileUtil.exists((String)(String.valueOf(projectDirName) + "/docroot/WEB-INF/service"))) {
                sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
                sb.append("kind=\"src\" path=\"docroot/WEB-INF/service\" />\n");
            }
            sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
            sb.append("kind=\"src\" path=\"docroot/WEB-INF/src\" />\n");
            sb.append("\t<classpathentry kind=\"src\" path=\"/portal\" />\n");
            sb.append("\t<classpathentry kind=\"con\" ");
            sb.append("path=\"org.eclipse.jdt.launching.JRE_CONTAINER\" />\n");
            if (FileUtil.exists((String)(String.valueOf(projectDirName) + "/docroot/WEB-INF/test"))) {
                sb.append("\t<classpathentry excluding=\"**/.svn/**|.svn/\" ");
                sb.append("kind=\"src\" path=\"docroot/WEB-INF/test\" />\n");
            }
            this._addClasspathEntry(sb, "/portal/lib/development/activation.jar");
            this._addClasspathEntry(sb, "/portal/lib/development/annotations.jar");
            this._addClasspathEntry(sb, "/portal/lib/development/jsp-api.jar");
            this._addClasspathEntry(sb, "/portal/lib/development/mail.jar");
            this._addClasspathEntry(sb, "/portal/lib/development/servlet-api.jar");
            this._addClasspathEntry(sb, "/portal/lib/global/portlet.jar");
            for (String jar : portalJars) {
                this._addClasspathEntry(sb, "/portal/lib/portal/" + jar);
            }
            this._addClasspathEntry(sb, "/portal/portal-service/portal-service.jar");
            this._addClasspathEntry(sb, "/portal/util-bridges/util-bridges.jar");
            this._addClasspathEntry(sb, "/portal/util-java/util-java.jar");
            this._addClasspathEntry(sb, "/portal/util-taglib/util-taglib.jar");
            for (String jar : customJars) {
                if (libDirPath.contains("/tmp/WEB-INF/lib")) {
                    this._addClasspathEntry(sb, "tmp/WEB-INF/lib/" + jar);
                    continue;
                }
                this._addClasspathEntry(sb, "docroot/WEB-INF/lib/" + jar);
            }
            sb.append("\t<classpathentry kind=\"output\" path=\"bin\" />\n");
            sb.append("</classpath>");
            classpathFile = new File(String.valueOf(projectDirName) + "/.classpath");
            System.out.println("Updating " + classpathFile);
            FileUtil.write((File)classpathFile, (String)sb.toString());
        }
        if (this._svn) {
            String projectFileName = "\"" + projectFile + "\"";
            try {
                this._exec(_SVN_INFO + projectFileName);
            }
            catch (Exception exception) {
                this._exec(_SVN_ADD + projectFileName);
            }
            if (javaProject) {
                String classpathFileName = "\"" + classpathFile + "\"";
                try {
                    this._exec(_SVN_INFO + classpathFileName);
                }
                catch (Exception exception) {
                    this._exec(_SVN_ADD + classpathFileName);
                }
            }
            File tempFile = File.createTempFile("svn-ignores-", null, null);
            try {
                FileUtil.write((File)tempFile, (String)"bin\ntmp");
                this._exec("svn propset svn:ignore -F \"" + tempFile.getCanonicalPath() + "\" \"" + projectDirName + "\"");
            }
            finally {
                FileUtil.delete((File)tempFile);
            }
        }
    }

    public void updateLibIgnores(File libDir, String[] jars) throws Exception {
        String libDirName;
        File tempFile;
        block10: {
            block11: {
                if (!this._isSVNDir(libDir)) {
                    return;
                }
                tempFile = null;
                libDirName = "\"" + libDir.getCanonicalPath() + "\"";
                Object[] oldIgnores = this._exec(_SVN_GET_IGNORES + libDirName);
                Arrays.sort(oldIgnores);
                if (!Arrays.equals(oldIgnores, jars)) break block10;
                if (tempFile == null) break block11;
                FileUtil.delete(tempFile);
            }
            return;
        }
        try {
            tempFile = File.createTempFile("svn-ignores-", null, null);
            this._exec(_SVN_DEL_IGNORES + libDirName);
            if (jars.length == 0) {
                FileUtil.write((File)tempFile, (String)"");
            } else {
                StringBundler sb = new StringBundler(jars.length * 2);
                String[] stringArray = jars;
                int n = jars.length;
                int n2 = 0;
                while (n2 < n) {
                    String jar = stringArray[n2];
                    sb.append(jar);
                    sb.append("\n");
                    ++n2;
                }
                FileUtil.write((File)tempFile, (String)sb.toString());
            }
            this._exec("svn propset svn:ignore -F \"" + tempFile.getCanonicalPath() + "\" \"" + libDirName + "\"");
            Object[] newIgnores = this._exec("svn propget svn:ignore \"" + libDirName + "\"");
            if (newIgnores.length > 0) {
                Arrays.sort(newIgnores);
            }
        }
        catch (Throwable throwable) {
            if (tempFile != null) {
                FileUtil.delete(tempFile);
            }
            throw throwable;
        }
        if (tempFile != null) {
            FileUtil.delete((File)tempFile);
        }
    }

    private void _addClasspathEntry(StringBundler sb, String jar) throws Exception {
        sb.append("\t<classpathentry kind=\"lib\" path=\"");
        sb.append(jar);
        sb.append("\" />\n");
    }

    private String[] _exec(String cmd) throws Exception {
        Process process = Runtime.getRuntime().exec(cmd);
        String[] stdout = this._getExecOutput(process.getInputStream());
        String[] stderr = this._getExecOutput(process.getErrorStream());
        if (stderr.length > 0) {
            StringBundler sb = new StringBundler(stderr.length * 3 + 3);
            sb.append("Received errors in executing '");
            sb.append(cmd);
            sb.append("'\n");
            String[] stringArray = stderr;
            int n = stderr.length;
            int n2 = 0;
            while (n2 < n) {
                String err = stringArray[n2];
                sb.append("\t");
                sb.append(err);
                sb.append("\n");
                ++n2;
            }
            throw new Exception(sb.toString());
        }
        return stdout;
    }

    private String[] _getExecOutput(InputStream is) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = null;
        try {
            unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(is));
            String line = unsyncBufferedReader.readLine();
            while (line != null) {
                if (Validator.isNotNull((String)(line = line.trim()))) {
                    list.add(line);
                }
                line = unsyncBufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            if (unsyncBufferedReader != null) {
                try {
                    unsyncBufferedReader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (unsyncBufferedReader != null) {
            try {
                unsyncBufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return list.toArray(new String[0]);
    }

    private boolean _isSVNDir(File libDir) {
        if (!libDir.exists()) {
            return false;
        }
        try {
            this._exec("svn info \"" + libDir + "\"");
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

