/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.InitUtil;
import com.liferay.portlet.translator.model.Translation;
import com.liferay.portlet.translator.util.TranslationWebCacheItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LangBuilder {
    public static final String AUTOMATIC_COPY = " (Automatic Copy)";
    public static final String AUTOMATIC_TRANSLATION = " (Automatic Translation)";
    private String _langDir;
    private String _langFile;
    private Properties _renameKeys;

    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length == 2) {
            new LangBuilder(args[0], args[1], null);
        } else if (args.length == 3) {
            new LangBuilder(args[0], args[1], args[2]);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public LangBuilder(String langDir, String langFile, String langCode) {
        try {
            this._langDir = langDir;
            this._langFile = langFile;
            File renameKeysFile = new File(String.valueOf(this._langDir) + "/rename.properties");
            if (renameKeysFile.exists()) {
                this._renameKeys = PropertiesUtil.load((String)FileUtil.read((File)renameKeysFile));
            }
            String content = this._orderProperties(new File(String.valueOf(this._langDir) + "/" + this._langFile + ".properties"));
            if (Validator.isNotNull((String)langCode) && !langCode.startsWith("$")) {
                this._createProperties(content, langCode);
            } else {
                this._createProperties(content, "ar");
                this._createProperties(content, "eu");
                this._createProperties(content, "bg");
                this._createProperties(content, "ca");
                this._createProperties(content, "zh_CN");
                this._createProperties(content, "zh_TW");
                this._createProperties(content, "cs");
                this._createProperties(content, "nl");
                this._createProperties(content, "et");
                this._createProperties(content, "fi");
                this._createProperties(content, "fr");
                this._createProperties(content, "gl");
                this._createProperties(content, "de");
                this._createProperties(content, "el");
                this._createProperties(content, "iw");
                this._createProperties(content, "hi_IN");
                this._createProperties(content, "hu");
                this._createProperties(content, "in");
                this._createProperties(content, "it");
                this._createProperties(content, "ja");
                this._createProperties(content, "ko");
                this._createProperties(content, "nb");
                this._createProperties(content, "fa");
                this._createProperties(content, "pl");
                this._createProperties(content, "pt_BR");
                this._createProperties(content, "pt_PT");
                this._createProperties(content, "ru");
                this._createProperties(content, "sk");
                this._createProperties(content, "es");
                this._createProperties(content, "sv");
                this._createProperties(content, "tr");
                this._createProperties(content, "uk");
                this._createProperties(content, "vi");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _createProperties(String content, String languageId) throws IOException {
        String translationId;
        File propertiesFile = new File(String.valueOf(this._langDir) + "/" + this._langFile + "_" + languageId + ".properties");
        Properties properties = new Properties();
        if (propertiesFile.exists()) {
            properties.load(new FileInputStream(propertiesFile));
        }
        if ((translationId = "en_" + languageId).equals("en_pt_BR")) {
            translationId = "en_pt";
        } else if (translationId.equals("en_pt_PT")) {
            translationId = "en_pt";
        } else if (translationId.equals("en_zh_CN")) {
            translationId = "en_zh";
        } else if (translationId.equals("en_zh_TW")) {
            translationId = "en_zt";
        } else if (translationId.equals("en_hi_IN")) {
            translationId = "en_hi";
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(propertiesFile));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int pos = (line = line.trim()).indexOf("=");
            if (pos != -1) {
                String renameKey;
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1, line.length());
                String translatedText = this._getProperty(properties, key);
                if (translatedText == null && this._renameKeys != null && (renameKey = this._renameKeys.getProperty(key)) != null) {
                    translatedText = this._getProperty(properties, key);
                }
                if (translatedText != null && (translatedText.indexOf("Babel Fish") != -1 || translatedText.indexOf("Yahoo! - 999") != -1)) {
                    translatedText = "";
                }
                if (translatedText == null || translatedText.equals("")) {
                    if (line.indexOf("{") != -1 || line.indexOf("<") != -1) {
                        translatedText = String.valueOf(value) + AUTOMATIC_COPY;
                    } else if (line.indexOf("[") != -1) {
                        pos = line.indexOf("[");
                        String baseKey = line.substring(0, pos);
                        translatedText = String.valueOf(this._getProperty(properties, baseKey)) + AUTOMATIC_COPY;
                    } else {
                        translatedText = key.equals("lang.dir") ? "ltr" : (key.equals("lang.line.begin") ? "left" : (key.equals("lang.line.end") ? "right" : (translationId.equals("en_el") && (key.equals("enabled") || key.equals("on") || key.equals("on-date")) ? "" : (translationId.equals("en_es") && key.equals("am") ? "" : (translationId.equals("en_it") && key.equals("am") ? "" : (translationId.equals("en_ja") && (key.equals("any") || key.equals("anytime") || key.equals("down") || key.equals("on") || key.equals("on-date") || key.equals("the")) ? "" : (translationId.equals("en_ko") && key.equals("the") ? "" : (Validator.isNull((String)(translatedText = this._translate(translationId, key, value, 0))) ? String.valueOf(value) + AUTOMATIC_COPY : String.valueOf(value) + AUTOMATIC_TRANSLATION))))))));
                    }
                }
                if (!Validator.isNotNull((String)translatedText)) continue;
                if (translatedText.indexOf("Babel Fish") != -1 || translatedText.indexOf("Yahoo! - 999") != -1) {
                    throw new IOException("IP was blocked because of over usage. Please use another IP.");
                }
                if (translatedText.indexOf("&#39;") != -1) {
                    translatedText = StringUtil.replace((String)translatedText, (String)"&#39;", (String)"'");
                }
                translatedText = StringUtil.replace((String)translatedText.trim(), (String)"  ", (String)" ");
                unsyncBufferedWriter.write(String.valueOf(key) + "=" + translatedText);
                unsyncBufferedWriter.newLine();
                unsyncBufferedWriter.flush();
                continue;
            }
            unsyncBufferedWriter.write(line);
            unsyncBufferedWriter.newLine();
            unsyncBufferedWriter.flush();
        }
        unsyncBufferedReader.close();
        unsyncBufferedWriter.close();
    }

    private String _getProperty(Properties properties, String key) throws IOException {
        String value = properties.getProperty(key);
        if (Validator.isNotNull((String)value)) {
            value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
        }
        return value;
    }

    private String _orderProperties(File propertiesFile) throws IOException {
        String content = FileUtil.read((File)propertiesFile);
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        UnsyncBufferedWriter unsyncBufferedWriter = new UnsyncBufferedWriter((Writer)new FileWriter(propertiesFile));
        TreeSet<String> messages = new TreeSet<String>();
        boolean begin = false;
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int pos = line.indexOf("=");
            if (pos != -1) {
                String key = line.substring(0, pos);
                String value = line.substring(pos + 1, line.length());
                messages.add(String.valueOf(key) + "=" + value);
            } else {
                if (begin && line.equals("")) {
                    this._sortAndWrite(unsyncBufferedWriter, messages);
                }
                if (line.equals("")) {
                    begin = !begin;
                }
                unsyncBufferedWriter.write(line);
                unsyncBufferedWriter.newLine();
            }
            unsyncBufferedWriter.flush();
        }
        if (messages.size() > 0) {
            this._sortAndWrite(unsyncBufferedWriter, messages);
        }
        unsyncBufferedReader.close();
        unsyncBufferedWriter.close();
        return FileUtil.read((File)propertiesFile);
    }

    private void _sortAndWrite(UnsyncBufferedWriter unsyncBufferedWriter, Set<String> messages) throws IOException {
        String[] messagesArray = messages.toArray(new String[messages.size()]);
        int i = 0;
        while (i < messagesArray.length) {
            unsyncBufferedWriter.write(messagesArray[i]);
            unsyncBufferedWriter.newLine();
            ++i;
        }
        messages.clear();
    }

    private String _translate(String translationId, String key, String fromText, int limit) {
        if (translationId.equals("en_ar") || translationId.equals("en_eu") || translationId.equals("en_bg") || translationId.equals("en_ca") || translationId.equals("en_cs") || translationId.equals("en_fi") || translationId.equals("en_gl") || translationId.equals("en_iw") || translationId.equals("en_hi") || translationId.equals("en_hu") || translationId.equals("en_in") || translationId.equals("en_nb") || translationId.equals("en_fa") || translationId.equals("en_pl") || translationId.equals("en_ru") || translationId.equals("en_sk") || translationId.equals("en_sv") || translationId.equals("en_tr") || translationId.equals("en_uk") || translationId.equals("en_vi") || translationId.equals("en_et")) {
            return null;
        }
        if (limit == 3) {
            return null;
        }
        String toText = null;
        try {
            System.out.println("Translating " + translationId + " " + key + " " + fromText);
            TranslationWebCacheItem wci = new TranslationWebCacheItem(translationId, fromText);
            Translation translation = (Translation)wci.convert("");
            toText = translation.getToText();
            if (toText != null && toText.indexOf("Babel Fish") != -1) {
                toText = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (toText == null) {
            return this._translate(translationId, key, fromText, ++limit);
        }
        if (Validator.isNotNull(toText)) {
            toText = String.valueOf(toText) + AUTOMATIC_TRANSLATION;
        }
        return toText;
    }
}

