/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparableRoute
implements Comparable<ComparableRoute> {
    private Map<String, String> _generatedParameters = new TreeMap<String, String>();
    private Set<String> _ignoredParameters = new TreeSet<String>();
    private Map<String, String> _implicitParameters = new TreeMap<String, String>();
    private Map<String, String> _overriddenParameters = new TreeMap<String, String>();
    private String _pattern;

    public static boolean hasRegex(String fragment) {
        return fragment.indexOf(":") != -1;
    }

    public static boolean isCaptureFragment(String fragment) {
        return fragment.indexOf("{") != -1;
    }

    public static boolean isMatchAny(String fragment) {
        return fragment.matches(".*\\{.+?:\\.\\*\\}.*");
    }

    public ComparableRoute(String pattern) {
        this._pattern = pattern;
    }

    public void addGeneratedParameter(String name, String pattern) {
        this._generatedParameters.put(name, pattern);
    }

    public void addIgnoredParameter(String name) {
        this._ignoredParameters.add(name);
    }

    public void addImplicitParameter(String name, String value) {
        this._implicitParameters.put(name, value);
    }

    public void addOverriddenParameter(String name, String value) {
        this._overriddenParameters.put(name, value);
    }

    @Override
    public int compareTo(ComparableRoute comparableRoute) {
        String[] _fragments = this._pattern.split("[/\\.](?!\\*)");
        String pattern = comparableRoute.getPattern();
        String[] fragments = pattern.split("[/\\.](?!\\*)");
        int i = 0;
        while (i < _fragments.length && i < fragments.length) {
            String _fragment = _fragments[i];
            String fragment = fragments[i];
            if (!ComparableRoute.isCaptureFragment(_fragment) && ComparableRoute.isCaptureFragment(fragment)) {
                return -1;
            }
            if (ComparableRoute.isCaptureFragment(_fragment) && !ComparableRoute.isCaptureFragment(fragment)) {
                return 1;
            }
            if (!ComparableRoute.isMatchAny(_fragment) && ComparableRoute.isMatchAny(fragment)) {
                return -1;
            }
            if (ComparableRoute.isMatchAny(_fragment) && !ComparableRoute.isMatchAny(fragment)) {
                return 1;
            }
            if (ComparableRoute.hasRegex(_fragment) && !ComparableRoute.hasRegex(fragment)) {
                return -1;
            }
            if (!ComparableRoute.hasRegex(_fragment) && ComparableRoute.hasRegex(fragment)) {
                return 1;
            }
            ++i;
        }
        if (i < fragments.length && i >= _fragments.length) {
            return -1;
        }
        if (i < _fragments.length && i >= fragments.length) {
            return 1;
        }
        Map<String, String> implicitParameters = comparableRoute.getImplicitParameters();
        if (this._implicitParameters.size() > implicitParameters.size()) {
            return -1;
        }
        if (this._implicitParameters.size() < implicitParameters.size()) {
            return 1;
        }
        return this._pattern.compareTo(comparableRoute.getPattern());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComparableRoute)) {
            return false;
        }
        ComparableRoute comparableRoute = (ComparableRoute)obj;
        return this.compareTo(comparableRoute) == 0;
    }

    public Map<String, String> getGeneratedParameters() {
        return this._generatedParameters;
    }

    public Set<String> getIgnoredParameters() {
        return this._ignoredParameters;
    }

    public Map<String, String> getImplicitParameters() {
        return this._implicitParameters;
    }

    public Map<String, String> getOverriddenParameters() {
        return this._overriddenParameters;
    }

    public String getPattern() {
        return this._pattern;
    }
}

