/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence;

import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutReference;
import com.liferay.portal.model.LayoutSoap;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.service.persistence.LayoutFinder;
import com.liferay.portal.service.persistence.LayoutUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutFinderImpl
extends BasePersistenceImpl<Layout>
implements LayoutFinder {
    public static String FIND_BY_NULL_FRIENDLY_URL = String.valueOf(LayoutFinder.class.getName()) + ".findByNullFriendlyURL";
    public static String FIND_BY_C_P_P = String.valueOf(LayoutFinder.class.getName()) + ".findByC_P_P";

    public List<Layout> findByNullFriendlyURL() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NULL_FRIENDLY_URL);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("Layout", LayoutImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<LayoutReference> findByC_P_P(long companyId, String portletId, String preferencesKey, String preferencesValue) throws SystemException {
        String preferences = "%<preference><name>" + preferencesKey + "</name><value>" + preferencesValue + "</value>%";
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_C_P_P);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("layoutPlid", Type.LONG);
            q.addScalar("preferencesPortletId", Type.STRING);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(portletId);
            qPos.add(String.valueOf(portletId) + "_INSTANCE_%");
            qPos.add(preferences);
            ArrayList<LayoutReference> layoutReferences = new ArrayList<LayoutReference>();
            for (Object[] array : q.list()) {
                Long layoutPlid = (Long)array[0];
                String preferencesPortletId = (String)array[1];
                Layout layout = LayoutUtil.findByPrimaryKey((long)layoutPlid);
                layoutReferences.add(new LayoutReference(LayoutSoap.toSoapModel((Layout)layout), preferencesPortletId));
            }
            ArrayList<LayoutReference> arrayList = layoutReferences;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

