/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchUserGroupGroupRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserGroupGroupRole;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.UserGroupGroupRoleLocalServiceBaseImpl;
import com.liferay.portal.service.persistence.UserGroupGroupRolePK;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroupGroupRoleLocalServiceImpl
extends UserGroupGroupRoleLocalServiceBaseImpl {
    public void addUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) throws PortalException, SystemException {
        this.checkGroupResource(groupId);
        long[] lArray = roleIds;
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
            UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByPrimaryKey(pk);
            if (userGroupGroupRole == null) {
                userGroupGroupRole = this.userGroupGroupRolePersistence.create(pk);
                this.userGroupGroupRolePersistence.update((BaseModel)userGroupGroupRole, false);
            }
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void addUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) throws PortalException, SystemException {
        this.checkGroupResource(groupId);
        long[] lArray = userGroupIds;
        int n = userGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userGroupId = lArray[n2];
            UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
            UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByPrimaryKey(pk);
            if (userGroupGroupRole == null) {
                userGroupGroupRole = this.userGroupGroupRolePersistence.create(pk);
                this.userGroupGroupRolePersistence.update((BaseModel)userGroupGroupRole, false);
            }
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void deleteUserGroupGroupRole(UserGroupGroupRole userGroupGroupRole) throws SystemException {
        this.userGroupGroupRolePersistence.remove((BaseModel)userGroupGroupRole);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) throws SystemException {
        long[] lArray = roleIds;
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
            try {
                this.userGroupGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupGroupRoleException noSuchUserGroupGroupRoleException) {}
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRoles(long userGroupId, long[] groupIds) throws SystemException {
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            this.userGroupGroupRolePersistence.removeByU_G(userGroupId, groupId);
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRoles(long[] userGroupIds, long groupId) throws SystemException {
        long[] lArray = userGroupIds;
        int n = userGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userGroupId = lArray[n2];
            this.userGroupGroupRolePersistence.removeByU_G(userGroupId, groupId);
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) throws SystemException {
        long[] lArray = userGroupIds;
        int n = userGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userGroupId = lArray[n2];
            UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
            try {
                this.userGroupGroupRolePersistence.remove(pk);
            }
            catch (NoSuchUserGroupGroupRoleException noSuchUserGroupGroupRoleException) {}
            ++n2;
        }
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRolesByGroupId(long groupId) throws SystemException {
        this.userGroupGroupRolePersistence.removeByGroupId(groupId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRolesByRoleId(long roleId) throws SystemException {
        this.userGroupGroupRolePersistence.removeByRoleId(roleId);
        PermissionCacheUtil.clearCache();
    }

    public void deleteUserGroupGroupRolesByUserGroupId(long userGroupId) throws SystemException {
        this.userGroupGroupRolePersistence.removeByUserGroupId(userGroupId);
        PermissionCacheUtil.clearCache();
    }

    public List<UserGroupGroupRole> getUserGroupGroupRoles(long userGroupId) throws SystemException {
        return this.userGroupGroupRolePersistence.findByUserGroupId(userGroupId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRoles(long userGroupId, long groupId) throws SystemException {
        return this.userGroupGroupRolePersistence.findByU_G(userGroupId, groupId);
    }

    public List<UserGroupGroupRole> getUserGroupGroupRolesByGroupAndRole(long groupId, long roleId) throws SystemException {
        return this.userGroupGroupRolePersistence.findByG_R(groupId, roleId);
    }

    public boolean hasUserGroupGroupRole(long userGroupId, long groupId, long roleId) throws SystemException {
        UserGroupGroupRolePK pk = new UserGroupGroupRolePK(userGroupId, groupId, roleId);
        UserGroupGroupRole userGroupGroupRole = this.userGroupGroupRolePersistence.fetchByPrimaryKey(pk);
        return userGroupGroupRole != null;
    }

    public boolean hasUserGroupGroupRole(long userGroupId, long groupId, String roleName) throws PortalException, SystemException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        long companyId = userGroup.getCompanyId();
        Role role = this.rolePersistence.findByC_N(companyId, roleName);
        long roleId = role.getRoleId();
        return this.hasUserGroupGroupRole(userGroupId, groupId, roleId);
    }

    protected void checkGroupResource(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        this.resourceLocalService.addResource(group.getCompanyId(), Group.class.getName(), 4, String.valueOf(groupId));
    }
}

