/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Ticket;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.TicketLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;

public class TicketLocalServiceImpl
extends TicketLocalServiceBaseImpl {
    public Ticket addTicket(long companyId, String className, long classPK, Date expirationDate, ServiceContext serviceContext) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        long ticketId = this.counterLocalService.increment();
        Ticket ticket = this.ticketPersistence.create(ticketId);
        ticket.setCompanyId(companyId);
        ticket.setCreateDate(now);
        ticket.setClassNameId(classNameId);
        ticket.setClassPK(classPK);
        ticket.setKey(PortalUUIDUtil.generate());
        ticket.setExpirationDate(expirationDate);
        this.ticketPersistence.update((BaseModel)ticket, false);
        return ticket;
    }

    public Ticket getTicket(String key) throws PortalException, SystemException {
        return this.ticketPersistence.findByKey(key);
    }
}

