/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.AddressCityException;
import com.liferay.portal.AddressStreetException;
import com.liferay.portal.AddressZipException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.base.AddressLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressLocalServiceImpl
extends AddressLocalServiceBaseImpl {
    public Address addAddress(long userId, String className, long classPK, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, int typeId, boolean mailing, boolean primary) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        this.validate(0L, user.getCompanyId(), classNameId, classPK, street1, city, zip, regionId, countryId, typeId, mailing, primary);
        long addressId = this.counterLocalService.increment();
        Address address = this.addressPersistence.create(addressId);
        address.setCompanyId(user.getCompanyId());
        address.setUserId(user.getUserId());
        address.setUserName(user.getFullName());
        address.setCreateDate(now);
        address.setModifiedDate(now);
        address.setClassNameId(classNameId);
        address.setClassPK(classPK);
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setStreet3(street3);
        address.setCity(city);
        address.setZip(zip);
        address.setRegionId(regionId);
        address.setCountryId(countryId);
        address.setTypeId(typeId);
        address.setMailing(mailing);
        address.setPrimary(primary);
        this.addressPersistence.update((BaseModel)address, false);
        return address;
    }

    @Override
    public void deleteAddress(long addressId) throws PortalException, SystemException {
        this.addressPersistence.remove(addressId);
    }

    public void deleteAddresses(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.addressPersistence.removeByC_C_C(companyId, classNameId, classPK);
    }

    @Override
    public Address getAddress(long addressId) throws PortalException, SystemException {
        return this.addressPersistence.findByPrimaryKey(addressId);
    }

    public List<Address> getAddresses() throws SystemException {
        return this.addressPersistence.findAll();
    }

    public List<Address> getAddresses(long companyId, String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.addressPersistence.findByC_C_C(companyId, classNameId, classPK);
    }

    public Address updateAddress(long addressId, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, int typeId, boolean mailing, boolean primary) throws PortalException, SystemException {
        this.validate(addressId, 0L, 0L, 0L, street1, city, zip, regionId, countryId, typeId, mailing, primary);
        Address address = this.addressPersistence.findByPrimaryKey(addressId);
        address.setModifiedDate(new Date());
        address.setStreet1(street1);
        address.setStreet2(street2);
        address.setStreet3(street3);
        address.setCity(city);
        address.setZip(zip);
        address.setRegionId(regionId);
        address.setCountryId(countryId);
        address.setTypeId(typeId);
        address.setMailing(mailing);
        address.setPrimary(primary);
        this.addressPersistence.update((BaseModel)address, false);
        return address;
    }

    protected void validate(long addressId, long companyId, long classNameId, long classPK, String street1, String city, String zip, long regionId, long countryId, int typeId, boolean mailing, boolean primary) throws PortalException, SystemException {
        if (Validator.isNull((String)street1)) {
            throw new AddressStreetException();
        }
        if (Validator.isNull((String)city)) {
            throw new AddressCityException();
        }
        if (Validator.isNull((String)zip)) {
            throw new AddressZipException();
        }
        if (addressId > 0L) {
            Address address = this.addressPersistence.findByPrimaryKey(addressId);
            companyId = address.getCompanyId();
            classNameId = address.getClassNameId();
            classPK = address.getClassPK();
        }
        if (classNameId == PortalUtil.getClassNameId(Account.class) || classNameId == PortalUtil.getClassNameId(Contact.class) || classNameId == PortalUtil.getClassNameId(Organization.class)) {
            this.listTypeService.validate(typeId, classNameId, ".address");
        }
        this.validate(addressId, companyId, classNameId, classPK, mailing, primary);
    }

    protected void validate(long addressId, long companyId, long classNameId, long classPK, boolean mailing, boolean primary) throws SystemException {
        if (mailing) {
            for (Address address : this.addressPersistence.findByC_C_C_M(companyId, classNameId, classPK, mailing)) {
                if (addressId > 0L && address.getAddressId() == addressId) continue;
                address.setMailing(false);
                this.addressPersistence.update((BaseModel)address, false);
            }
        }
        if (primary) {
            for (Address address : this.addressPersistence.findByC_C_C_P(companyId, classNameId, classPK, primary)) {
                if (addressId > 0L && address.getAddressId() == addressId) continue;
                address.setPrimary(false);
                this.addressPersistence.update((BaseModel)address, false);
            }
        }
    }
}

