/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Randomizer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.User;
import com.liferay.portal.security.pwd.BasicToolkit;
import com.liferay.portal.service.PasswordTrackerLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.words.util.WordsUtil;
import com.liferay.util.PwdGenerator;
import java.util.Arrays;
import java.util.Date;

public class PasswordPolicyToolkit
extends BasicToolkit {
    private char[] _alphanumericCharsetArray;
    private String _completeCharset;
    private char[] _lowerCaseCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_LOWERCASE);
    private char[] _numbersCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_NUMBERS);
    private char[] _symbolsCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_SYMBOLS);
    private char[] _upperCaseCharsetArray = this.getSortedCharArray(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_UPPERCASE);

    public PasswordPolicyToolkit() {
        this._alphanumericCharsetArray = ArrayUtil.append((char[][])new char[][]{this._lowerCaseCharsetArray, this._upperCaseCharsetArray, this._numbersCharsetArray});
        Arrays.sort(this._alphanumericCharsetArray);
        StringBundler sb = new StringBundler(4);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_LOWERCASE);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_NUMBERS);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_SYMBOLS);
        sb.append(PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_CHARSET_UPPERCASE);
        this._completeCharset = sb.toString();
    }

    public String generate(PasswordPolicy passwordPolicy) {
        if (PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_GENERATOR.equals("static")) {
            return this.generateStatic(passwordPolicy);
        }
        return this.generateDynamic(passwordPolicy);
    }

    public void validate(long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        if (passwordPolicy.isCheckSyntax()) {
            if (!passwordPolicy.isAllowDictionaryWords() && WordsUtil.isDictionaryWord(password1)) {
                throw new UserPasswordException(2);
            }
            if (password1.length() < passwordPolicy.getMinLength()) {
                throw new UserPasswordException(4);
            }
            if (this.getUsageCount(password1, this._alphanumericCharsetArray) < passwordPolicy.getMinAlphanumeric() || this.getUsageCount(password1, this._lowerCaseCharsetArray) < passwordPolicy.getMinLowerCase() || this.getUsageCount(password1, this._numbersCharsetArray) < passwordPolicy.getMinNumbers() || this.getUsageCount(password1, this._symbolsCharsetArray) < passwordPolicy.getMinSymbols() || this.getUsageCount(password1, this._upperCaseCharsetArray) < passwordPolicy.getMinUpperCase()) {
                throw new UserPasswordException(8);
            }
        }
        if (!passwordPolicy.isChangeable()) {
            throw new UserPasswordException(5);
        }
        if (userId != 0L) {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            Date passwordModfiedDate = user.getPasswordModifiedDate();
            if (passwordModfiedDate != null) {
                Date now = new Date();
                long passwordModificationElapsedTime = now.getTime() - passwordModfiedDate.getTime();
                long userCreationElapsedTime = now.getTime() - user.getCreateDate().getTime();
                long minAge = passwordPolicy.getMinAge() * 1000L;
                if (passwordModificationElapsedTime < minAge && userCreationElapsedTime > minAge) {
                    throw new UserPasswordException(9);
                }
            }
            if (PasswordTrackerLocalServiceUtil.isSameAsCurrentPassword((long)userId, (String)password1)) {
                throw new UserPasswordException(6);
            }
            if (!PasswordTrackerLocalServiceUtil.isValidPassword((long)userId, (String)password1)) {
                throw new UserPasswordException(1);
            }
        }
    }

    protected String generateDynamic(PasswordPolicy passwordPolicy) {
        int count;
        int alphanumericMinLength = Math.max(passwordPolicy.getMinAlphanumeric(), passwordPolicy.getMinLowerCase() + passwordPolicy.getMinNumbers() + passwordPolicy.getMinUpperCase());
        int passwordMinLength = Math.max(passwordPolicy.getMinLength(), alphanumericMinLength + passwordPolicy.getMinSymbols());
        StringBundler sb = new StringBundler(passwordMinLength);
        if (passwordPolicy.getMinLowerCase() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinLowerCase(), this._lowerCaseCharsetArray));
        }
        if (passwordPolicy.getMinNumbers() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinNumbers(), this._numbersCharsetArray));
        }
        if (passwordPolicy.getMinSymbols() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinSymbols(), this._symbolsCharsetArray));
        }
        if (passwordPolicy.getMinUpperCase() > 0) {
            sb.append(this.getRandomString(passwordPolicy.getMinUpperCase(), this._upperCaseCharsetArray));
        }
        if (alphanumericMinLength > passwordPolicy.getMinAlphanumeric()) {
            count = alphanumericMinLength - passwordPolicy.getMinAlphanumeric();
            sb.append(this.getRandomString(count, this._alphanumericCharsetArray));
        }
        if (passwordMinLength > alphanumericMinLength + passwordPolicy.getMinSymbols()) {
            count = passwordMinLength - (alphanumericMinLength + passwordPolicy.getMinSymbols());
            sb.append(PwdGenerator.getPassword((String)this._completeCharset, (int)count));
        }
        Randomizer randomizer = Randomizer.getInstance();
        return randomizer.randomize(sb.toString());
    }

    protected String generateStatic(PasswordPolicy passwordPolicy) {
        return PropsValues.PASSWORDS_PASSWORDPOLICYTOOLKIT_STATIC;
    }

    protected String getRandomString(int count, char[] charArray) {
        StringBundler sb = new StringBundler(count);
        Randomizer randomizer = Randomizer.getInstance();
        int i = 0;
        while (i < count) {
            int index = randomizer.nextInt(charArray.length);
            sb.append(charArray[index]);
            ++i;
        }
        return sb.toString();
    }

    protected char[] getSortedCharArray(String s) {
        char[] charArray = s.toCharArray();
        Arrays.sort(charArray);
        return charArray;
    }

    protected int getUsageCount(String s, char[] charArray) {
        int count = 0;
        int i = 0;
        while (i < s.length()) {
            if (Arrays.binarySearch(charArray, s.charAt(i)) >= 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

