/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.admin.util.OmniadminUtil;
import javax.portlet.PortletRequest;

public abstract class BasePermissionChecker
implements PermissionChecker {
    protected User user;
    protected long defaultUserId;
    protected boolean signedIn;
    protected boolean checkGuest;
    protected Boolean omniadmin;
    protected Role ownerRole;
    private static Log _log = LogFactoryUtil.getLog(BasePermissionChecker.class);

    public long getCompanyId() {
        return this.user.getCompanyId();
    }

    public long getOwnerRoleId() {
        return this.ownerRole.getRoleId();
    }

    public long[] getRoleIds(long userId, long groupId) {
        return PermissionChecker.DEFAULT_ROLE_IDS;
    }

    public long getUserId() {
        return this.user.getUserId();
    }

    public boolean hasOwnerPermission(long companyId, String name, long primKey, long ownerId, String actionId) {
        return this.hasOwnerPermission(companyId, name, String.valueOf(primKey), ownerId, actionId);
    }

    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        return this.hasPermission(groupId, name, String.valueOf(primKey), actionId);
    }

    public void init(User user, boolean checkGuest) {
        this.user = user;
        if (user.isDefaultUser()) {
            this.defaultUserId = user.getUserId();
            this.signedIn = false;
        } else {
            try {
                this.defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)user.getCompanyId());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            this.signedIn = true;
        }
        this.checkGuest = checkGuest;
        try {
            this.ownerRole = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"Owner");
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public boolean isOmniadmin() {
        if (this.omniadmin == null) {
            this.omniadmin = OmniadminUtil.isOmniadmin(this.getUserId());
        }
        return this.omniadmin;
    }

    public void resetValues() {
    }

    public void setCheckGuest(boolean checkGuest) {
        this.checkGuest = checkGuest;
    }

    public void setValues(PortletRequest portletRequest) {
    }
}

