/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import com.liferay.portal.util.PropsValues;

public class FullNameGeneratorFactory {
    private static Log _log = LogFactoryUtil.getLog(FullNameValidatorFactory.class);
    private static FullNameGenerator _fullNameGenerator;

    public static FullNameGenerator getInstance() {
        if (_fullNameGenerator == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Instantiate " + PropsValues.USERS_FULL_NAME_GENERATOR));
            }
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            try {
                _fullNameGenerator = (FullNameGenerator)classLoader.loadClass(PropsValues.USERS_FULL_NAME_GENERATOR).newInstance();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Return " + _fullNameGenerator.getClass().getName()));
        }
        return _fullNameGenerator;
    }

    public static void setInstance(FullNameGenerator fullNameValidator) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set " + fullNameValidator.getClass().getName()));
        }
        _fullNameGenerator = fullNameValidator;
    }
}

