/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.ruby;

import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.scripting.ruby.BeanGlobalVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.IAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyExecutor
implements ScriptingExecutor {
    public static final String LANGUAGE = "ruby";
    private Ruby _ruby;

    public RubyExecutor() {
        RubyInstanceConfig rubyInstanceConfig = new RubyInstanceConfig();
        rubyInstanceConfig.setLoader(PortalClassLoaderUtil.getClassLoader());
        this._ruby = JavaEmbedUtils.initialize(new ArrayList(), (RubyInstanceConfig)rubyInstanceConfig);
    }

    public void clearCache() {
    }

    public String getLanguage() {
        return LANGUAGE;
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for Ruby");
        }
        try {
            GlobalVariables globalVariables = this._ruby.getGlobalVariables();
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                String inputName = entry.getKey();
                Object inputObject = entry.getValue();
                if (!inputName.startsWith("$")) {
                    inputName = "$" + inputName;
                }
                BeanGlobalVariable beanGlobalVariable = new BeanGlobalVariable(this._ruby, inputObject, inputObject.getClass());
                globalVariables.define(inputName, (IAccessor)beanGlobalVariable);
            }
            this._ruby.evalScriptlet(script);
            if (outputNames == null) {
                return null;
            }
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, globalVariables.get(outputName));
            }
            HashMap<String, Object> hashMap = outputObjects;
            return hashMap;
        }
        catch (RaiseException re) {
            throw new ScriptingException(String.valueOf(re.getException().message.asJavaString()) + "\n\n", (Throwable)re);
        }
        finally {
            JavaEmbedUtils.terminate((Ruby)this._ruby);
        }
    }
}

