/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.groovy;

import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyExecutor
implements ScriptingExecutor {
    public static final String CACHE_NAME = GroovyExecutor.class.getName();
    public static final String LANGUAGE = "groovy";
    private GroovyShell _groovyShell;

    public void clearCache() {
        SingleVMPoolUtil.clear((String)CACHE_NAME);
    }

    public String getLanguage() {
        return LANGUAGE;
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for Groovy");
        }
        Script compiledScript = this.getCompiledScript(script);
        Binding binding = new Binding(inputObjects);
        compiledScript.setBinding(binding);
        compiledScript.run();
        if (outputNames == null) {
            return null;
        }
        HashMap<String, Object> outputObjects = new HashMap<String, Object>();
        for (String outputName : outputNames) {
            outputObjects.put(outputName, binding.getVariable(outputName));
        }
        return outputObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Script getCompiledScript(String script) {
        String key;
        Script compiledScript;
        if (this._groovyShell == null) {
            GroovyExecutor groovyExecutor = this;
            synchronized (groovyExecutor) {
                this._groovyShell = new GroovyShell();
            }
        }
        if ((compiledScript = (Script)SingleVMPoolUtil.get((String)CACHE_NAME, (String)(key = String.valueOf(script.hashCode())))) == null) {
            compiledScript = this._groovyShell.parse(script);
            SingleVMPoolUtil.put((String)CACHE_NAME, (String)key, (Object)compiledScript);
        }
        return compiledScript;
    }
}

