/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting;

import com.liferay.portal.util.PropsValues;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassVisibilityChecker {
    public static final String ALL_CLASSES = "all_classes";
    private static Set<String> _forbiddenClasses = new HashSet<String>(Arrays.asList(PropsValues.SCRIPTING_FORBIDDEN_CLASSES));
    private boolean _allowAll;
    private Set<Pattern> _allowedPatterns;
    private boolean _denyAll;

    public ClassVisibilityChecker(Set<String> allowedClasses) {
        if (allowedClasses != null && allowedClasses.contains(ALL_CLASSES)) {
            this._allowAll = true;
        }
        if (_forbiddenClasses.contains(ALL_CLASSES)) {
            this._denyAll = true;
        }
        if (!this._allowAll && !this._denyAll) {
            this._allowedPatterns = new HashSet<Pattern>();
            for (String allowedClass : allowedClasses) {
                Pattern allowedPattern = Pattern.compile(allowedClass);
                this._allowedPatterns.add(allowedPattern);
            }
        }
    }

    public boolean isVisible(String className) {
        if (this._denyAll || _forbiddenClasses.contains(className)) {
            return false;
        }
        if (this._allowAll) {
            return true;
        }
        for (Pattern allowedPattern : this._allowedPatterns) {
            Matcher matcher = allowedPattern.matcher(className);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

