/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.statistics;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.monitoring.statistics.DataSample;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSampleThreadLocal
implements Cloneable {
    private static ThreadLocal<DataSampleThreadLocal> _dataSampleThreadLocal = new AutoResetThreadLocal(DataSampleThreadLocal.class + "._dataSampleThreadLocal", (Object)new DataSampleThreadLocal());
    private static boolean _monitoringDataSampleThreadLocal = PropsValues.MONITORING_DATA_SAMPLE_THREAD_LOCAL;
    private List<DataSample> _dataSamples = new ArrayList<DataSample>();
    private long _monitorTime = System.currentTimeMillis();

    public static void addDataSample(DataSample dataSample) {
        if (!_monitoringDataSampleThreadLocal) {
            return;
        }
        _dataSampleThreadLocal.get()._addDataSample(dataSample);
    }

    public static void clearDataSamples() {
        _dataSampleThreadLocal.remove();
    }

    public static List<DataSample> getDataSamples() {
        if (!_monitoringDataSampleThreadLocal) {
            return Collections.EMPTY_LIST;
        }
        return _dataSampleThreadLocal.get()._getDataSamples();
    }

    public static boolean isMonitoringDataSampleThreadLocal() {
        return _monitoringDataSampleThreadLocal;
    }

    public static void setMonitoringDataSampleThreadLocal(boolean monitoringDataSampleThreadLocal) {
        _monitoringDataSampleThreadLocal = monitoringDataSampleThreadLocal;
    }

    public Object clone() {
        return new DataSampleThreadLocal();
    }

    public long getMonitorTime() {
        return this._monitorTime;
    }

    private DataSampleThreadLocal() {
    }

    private void _addDataSample(DataSample dataSample) {
        this._dataSamples.add(dataSample);
    }

    private List<DataSample> _getDataSamples() {
        return this._dataSamples;
    }
}

